/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.rewriter.xml;

import com.day.cq.rewriter.xml.JaxpSAXParser;
import com.day.cq.rewriter.xml.MemoryStore;
import com.day.cq.rewriter.xml.XSLTProcessorErrorListener;
import com.day.cq.rewriter.xml.XSLTProcessorException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.validity.AggregatedValidity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLTProcessorImpl
implements URIResolver {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static MemoryStore store = null;
    protected SAXTransformerFactory factory;
    protected boolean incrementalProcessing = false;
    protected SourceResolver resolver;
    protected boolean checkIncludes = true;
    protected Map<String, List<Object[]>> includesMap = new HashMap<String, List<Object[]>>();
    protected JaxpSAXParser saxParser = new JaxpSAXParser();

    public XSLTProcessorImpl(SourceResolver resolver) {
        this.resolver = resolver;
        this.factory = this.getTransformerFactory();
    }

    private Logger getLogger() {
        return this.logger;
    }

    public void setIncrementalProcessing(boolean incrementalProcessing) {
        this.incrementalProcessing = incrementalProcessing;
    }

    public void setCheckIncludes(boolean checkIncludes) {
        this.checkIncludes = checkIncludes;
    }

    public TransformerHandler getTransformerHandler(Source stylesheet) throws XSLTProcessorException {
        TransformerHandlerAndValidity validity = this.getTransformerHandlerAndValidity(stylesheet);
        return validity.getTransfomerHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransformerHandlerAndValidity getTransformerHandlerAndValidity(Source stylesheet) throws XSLTProcessorException {
        TransformerHandlerAndValidity handlerAndValidity;
        String id = stylesheet.getURI();
        try {
            handlerAndValidity = this.getTemplates(stylesheet, id);
            if (handlerAndValidity != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Reusing Templates for " + id);
                }
                return handlerAndValidity;
            }
        }
        catch (Exception e) {
            throw new XSLTProcessorException("Error retrieving template", e);
        }
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.factory.getClass().getClassLoader());
        XSLTProcessorErrorListener errorListener = new XSLTProcessorErrorListener(this.getLogger(), stylesheet.getURI());
        try {
            SourceValidity validity;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Creating new Templates for " + id);
            }
            this.factory.setErrorListener(errorListener);
            TemplatesHandler templatesHandler = this.factory.newTemplatesHandler();
            templatesHandler.setSystemId(id);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Source = " + stylesheet + ", templatesHandler = " + templatesHandler);
            }
            if ((validity = stylesheet.getValidity()) != null && this.checkIncludes) {
                this.includesMap.put(id, new ArrayList());
            }
            try {
                List<Object[]> includes;
                this.sourceToSAX(stylesheet, templatesHandler);
                Templates template = templatesHandler.getTemplates();
                if (null == template) {
                    throw new XSLTProcessorException("Unable to create templates for stylesheet: " + stylesheet.getURI());
                }
                if (template.getClass().getName().equals("org.apache.xalan.templates.StylesheetRoot")) {
                    Method method = template.getClass().getMethod("setHref", String.class);
                    method.invoke((Object)template, id);
                }
                this.putTemplates(template, stylesheet, id);
                TransformerHandler handler = this.factory.newTransformerHandler(template);
                handler.getTransformer().setErrorListener(new XSLTProcessorErrorListener(this.getLogger(), stylesheet.getURI()));
                handler.getTransformer().setURIResolver(this);
                AggregatedValidity aggregated = null;
                if (validity != null && this.checkIncludes && (includes = this.includesMap.get(id)) != null) {
                    aggregated = new AggregatedValidity();
                    aggregated.add(validity);
                    for (int i = includes.size() - 1; i >= 0; --i) {
                        aggregated.add((SourceValidity)includes.get(i)[1]);
                    }
                    validity = aggregated;
                }
                handlerAndValidity = new MyTransformerHandlerAndValidity(handler, validity);
            }
            finally {
                Thread.currentThread().setContextClassLoader(null);
                if (this.checkIncludes) {
                    this.includesMap.remove(id);
                }
            }
            TransformerHandlerAndValidity transformerHandlerAndValidity = handlerAndValidity;
            return transformerHandlerAndValidity;
        }
        catch (Exception e) {
            Throwable realEx = errorListener.getThrowable();
            if (realEx == null) {
                realEx = e;
            }
            if (realEx instanceof RuntimeException) {
                throw (RuntimeException)realEx;
            }
            if (realEx instanceof XSLTProcessorException) {
                throw (XSLTProcessorException)realEx;
            }
            throw new XSLTProcessorException("Exception when creating Transformer from " + stylesheet.getURI(), realEx);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    private void sourceToSAX(Source source, ContentHandler handler) throws SAXException, IOException, SourceException {
        this.saxParser.parse(XSLTProcessorImpl.getInputSource(source), handler);
    }

    public void transform(Source source, Source stylesheet, Map<String, Object> params, Result result) throws XSLTProcessorException {
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Transform source = " + source + ", stylesheet = " + stylesheet + ", parameters = " + params + ", result = " + result);
            }
            TransformerHandler handler = this.getTransformerHandler(stylesheet);
            if (params != null) {
                Transformer transformer = handler.getTransformer();
                transformer.clearParameters();
                for (Map.Entry<String, Object> current : params.entrySet()) {
                    transformer.setParameter(current.getKey(), current.getValue());
                }
            }
            handler.setResult(result);
            this.sourceToSAX(source, handler);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Transform done");
            }
        }
        catch (SAXException e) {
            String message = "Error in running Transformation";
            throw new XSLTProcessorException("Error in running Transformation", e);
        }
        catch (Exception e) {
            String message = "Error in running Transformation";
            throw new XSLTProcessorException("Error in running Transformation", e);
        }
    }

    private SAXTransformerFactory getTransformerFactory() {
        SAXTransformerFactory _factory = (SAXTransformerFactory)TransformerFactory.newInstance();
        _factory.setURIResolver(this);
        if (_factory.getClass().getName().equals("org.apache.xalan.processor.TransformerFactoryImpl")) {
            _factory.setAttribute("http://xml.apache.org/xalan/features/incremental", this.incrementalProcessing);
        }
        if (_factory.getClass().getName().equals("net.sf.saxon.TransformerFactoryImpl")) {
            _factory.setAttribute("http://saxon.sf.net/feature/version-warning", Boolean.FALSE);
        }
        return _factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransformerHandlerAndValidity getTemplates(Source stylesheet, String id) throws IOException, TransformerException {
        boolean isValid;
        SourceValidity newValidity;
        if (store == null) {
            return null;
        }
        String key = "XSLTTemplate: " + id + '(' + this.factory.getClass().getName() + ')';
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("getTemplates: stylesheet " + id);
        }
        if ((newValidity = stylesheet.getValidity()) == null) {
            store.remove(key);
            return null;
        }
        Object[] templateAndValidityAndIncludes = (Object[])store.get(key);
        if (templateAndValidityAndIncludes == null) {
            return null;
        }
        SourceValidity storedValidity = (SourceValidity)templateAndValidityAndIncludes[1];
        int valid = storedValidity.isValid();
        if (valid == 0) {
            valid = storedValidity.isValid(newValidity);
            isValid = valid == 1;
        } else {
            boolean bl = isValid = valid == 1;
        }
        if (!isValid) {
            store.remove(key);
            return null;
        }
        if (this.checkIncludes) {
            AggregatedValidity aggregated = null;
            List includes = (List)templateAndValidityAndIncludes[2];
            if (includes != null) {
                aggregated = new AggregatedValidity();
                aggregated.add(storedValidity);
                for (int i = includes.size() - 1; i >= 0; --i) {
                    Object[] pair = (Object[])includes.get(i);
                    storedValidity = (SourceValidity)pair[1];
                    aggregated.add(storedValidity);
                    valid = storedValidity.isValid();
                    isValid = false;
                    if (valid == 0) {
                        Source includedSource = null;
                        try {
                            includedSource = this.resolver.resolveURI((String)pair[0]);
                            SourceValidity included = includedSource.getValidity();
                            if (included != null) {
                                valid = storedValidity.isValid(included);
                                isValid = valid == 1;
                            }
                            this.resolver.release(includedSource);
                        }
                        catch (Throwable throwable) {
                            this.resolver.release(includedSource);
                            throw throwable;
                        }
                    } else {
                        boolean bl = isValid = valid == 1;
                    }
                    if (isValid) continue;
                    store.remove(key);
                    return null;
                }
                storedValidity = aggregated;
            }
        }
        TransformerHandler handler = this.factory.newTransformerHandler((Templates)templateAndValidityAndIncludes[0]);
        handler.getTransformer().setErrorListener(new XSLTProcessorErrorListener(this.getLogger(), stylesheet.getURI()));
        handler.getTransformer().setURIResolver(this);
        return new MyTransformerHandlerAndValidity(handler, storedValidity);
    }

    private void putTemplates(Templates templates, Source stylesheet, String id) throws IOException {
        if (store == null) {
            return;
        }
        String key = "XSLTTemplate: " + id + '(' + this.factory.getClass().getName() + ')';
        SourceValidity validity = stylesheet.getValidity();
        if (null != validity) {
            Object[] templateAndValidityAndIncludes = new Object[3];
            templateAndValidityAndIncludes[0] = templates;
            templateAndValidityAndIncludes[1] = validity;
            if (this.checkIncludes) {
                templateAndValidityAndIncludes[2] = this.includesMap.get(id);
            }
            store.store(key, templateAndValidityAndIncludes);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public javax.xml.transform.Source resolve(String href, String base) throws TransformerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static InputSource getInputSource(Source source) throws IOException, SourceException {
        InputSource newObject = new InputSource(source.getInputStream());
        newObject.setSystemId(source.getURI());
        return newObject;
    }

    public static class MyTransformerHandlerAndValidity
    extends TransformerHandlerAndValidity {
        protected MyTransformerHandlerAndValidity(TransformerHandler handler, SourceValidity validity) {
            super(handler, validity);
        }
    }

    public static class TransformerHandlerAndValidity {
        private final TransformerHandler transformerHandler;
        private final SourceValidity transformerValidity;

        protected TransformerHandlerAndValidity(TransformerHandler transformerHandler, SourceValidity transformerValidity) {
            this.transformerHandler = transformerHandler;
            this.transformerValidity = transformerValidity;
        }

        public TransformerHandler getTransfomerHandler() {
            return this.transformerHandler;
        }

        public SourceValidity getTransfomerValidity() {
            return this.transformerValidity;
        }
    }
}

