/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.rewriter.xml.fop;

import com.day.cq.rewriter.xml.SourceResolverImpl;
import com.day.cq.rewriter.xml.fop.FontConfig;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.cocoon.xml.sax.AbstractSAXPipe;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.rewriter.ProcessingComponentConfiguration;
import org.apache.sling.rewriter.ProcessingContext;
import org.apache.sling.rewriter.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class FOPNGSerializer
extends AbstractSAXPipe
implements URIResolver,
Serializer {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected SourceResolver resolver;
    protected FopFactory fopfactory = FopFactory.newInstance();
    protected Fop fop;
    protected String mimetype;
    protected ByteArrayOutputStream cachingOS;
    protected OutputStream out;
    protected SlingHttpServletResponse response;
    private FontConfig fontConfig;

    public void init(ProcessingContext context, ProcessingComponentConfiguration config) throws IOException {
        File configFile;
        this.resolver = new SourceResolverImpl(context.getRequest().getResourceResolver(), context.getRequest(), context.getResponse());
        this.fopfactory.setURIResolver((URIResolver)this);
        File fontConfigDirectory = this.fontConfig.getFontConfigDirectory();
        if (fontConfigDirectory != null) {
            this.fopfactory.setFontBaseURL(fontConfigDirectory.toURI().toString());
        }
        if ((configFile = this.fontConfig.getUserConfigFile()) != null) {
            try {
                this.fopfactory.setUserConfig(configFile);
            }
            catch (SAXException e) {
                this.logger.error("FOP user config not applicable.", (Throwable)e);
            }
        }
        this.mimetype = (String)config.getConfiguration().get((Object)"mime-type");
        this.out = context.getOutputStream();
        this.cachingOS = new ByteArrayOutputStream();
        this.response = context.getResponse();
        this.setOutputStream(this.cachingOS);
    }

    public void dispose() {
    }

    public void setFontConfig(FontConfig fontConfig) {
        this.fontConfig = fontConfig;
    }

    private String getMimeType() {
        return this.mimetype;
    }

    private void setOutputStream(OutputStream out) throws IOException {
        FOUserAgent userAgent = this.fopfactory.newFOUserAgent();
        try {
            this.fop = this.fopfactory.newFop(this.getMimeType(), userAgent, out);
            this.setContentHandler(this.fop.getDefaultHandler());
        }
        catch (FOPException e) {
            this.logger.error("FOP setup failed", (Throwable)e);
            throw new IOException("Unable to setup fop: " + e.getLocalizedMessage());
        }
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        this.response.setContentType(this.mimetype);
        this.response.setCharacterEncoding(null);
        this.response.setContentLength(this.cachingOS.size());
        try {
            this.cachingOS.writeTo(this.out);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.xml.transform.Source resolve(String href, String base) throws TransformerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("resolve(href = " + href + ", base = " + base + "); resolver = " + this.resolver);
        }
        StreamSource streamSource = null;
        Source source = null;
        try {
            if (base == null || href.indexOf(":") > 1) {
                source = this.resolver.resolveURI(href);
            } else if (href.length() == 0) {
                source = this.resolver.resolveURI(base);
            } else if (!base.startsWith("file:")) {
                int lastPathElementPos = base.lastIndexOf(47);
                if (lastPathElementPos == -1) {
                    javax.xml.transform.Source source2 = null;
                    return source2;
                }
                source = this.resolver.resolveURI(base.substring(0, lastPathElementPos) + "/" + href);
            } else {
                File parent = new File(base.substring(5));
                File parent2 = new File(parent.getParentFile(), href);
                source = this.resolver.resolveURI(parent2.toURL().toExternalForm());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("source = " + source + ", system id = " + source.getURI());
            }
            streamSource = new StreamSource(new ReleaseSourceInputStream(source.getInputStream(), source, this.resolver), source.getURI());
        }
        catch (SourceException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Failed to resolve " + href + "(base = " + base + "), return null", (Throwable)e);
            }
            javax.xml.transform.Source source3 = null;
            return source3;
        }
        catch (MalformedURLException mue) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Failed to resolve " + href + "(base = " + base + "), return null", (Throwable)mue);
            }
            javax.xml.transform.Source source4 = null;
            return source4;
        }
        catch (IOException ioe) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Failed to resolve " + href + "(base = " + base + "), return null", (Throwable)ioe);
            }
            javax.xml.transform.Source source5 = null;
            return source5;
        }
        finally {
            if (streamSource == null) {
                this.resolver.release(source);
            }
        }
        return streamSource;
    }

    public static class ReleaseSourceInputStream
    extends InputStream {
        private InputStream delegate;
        private Source source;
        private SourceResolver sourceResolver;

        private ReleaseSourceInputStream(InputStream delegate, Source source, SourceResolver sourceResolver) {
            this.delegate = delegate;
            this.source = source;
            this.sourceResolver = sourceResolver;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                this.delegate.close();
            }
            finally {
                this.sourceResolver.release(this.source);
            }
        }

        public int read() throws IOException {
            return this.delegate.read();
        }

        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        public int available() throws IOException {
            return this.delegate.available();
        }

        public synchronized void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        public synchronized void reset() throws IOException {
            this.delegate.reset();
        }

        public boolean markSupported() {
            return this.delegate.markSupported();
        }
    }
}

