/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.rewriter.xml.fop;

import com.day.cq.rewriter.xml.fop.FontConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontConfigImpl
implements FontConfig {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String TMP_DIR = System.getProperty("java.io.tmpdir");
    private static final String FONT_CONFIG_ROOT = "/libs/wcm/core/content/pdf";
    private static final String FONT_CONFIG_FONTS = "/libs/wcm/core/content/pdf/fonts";
    public static final String FONT_CONFIG = "/libs/wcm/core/content/pdf/foconfig.xml";
    private SlingRepository repo;
    private File fontsDir;
    private File configFile;

    public File getFontConfigDirectory() {
        return this.fontsDir;
    }

    public File getUserConfigFile() {
        return this.configFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext ctx) {
        if (TMP_DIR != null) {
            File tmpDir = new File(TMP_DIR);
            this.fontsDir = new File(tmpDir, "fonts." + UUID.randomUUID());
            this.fontsDir.mkdir();
            this.fontsDir.deleteOnExit();
            Session session = null;
            try {
                session = this.repo.loginAdministrative(this.repo.getDefaultWorkspace());
                if (session.nodeExists(FONT_CONFIG)) {
                    this.configFile = this.createFile(session.getNode(FONT_CONFIG));
                }
                if (session.nodeExists(FONT_CONFIG_FONTS)) {
                    Node fonts = session.getNode(FONT_CONFIG_FONTS);
                    NodeIterator children = fonts.getNodes();
                    while (children.hasNext()) {
                        this.createFile((Node)children.next());
                    }
                }
            }
            catch (RepositoryException e) {
                this.logger.error("Failed exporting FOP font data.", (Throwable)e);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }
    }

    protected void deactivate(ComponentContext ctx) {
        this.deleteFile(this.fontsDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFile(Node node) throws RepositoryException {
        block6: {
            if (node.hasProperty("jcr:content/jcr:data")) {
                File file;
                Property data = node.getProperty("jcr:content/jcr:data");
                Binary binary = data.getBinary();
                FileOutputStream out = null;
                InputStream in = null;
                try {
                    File result = new File(this.fontsDir, node.getName());
                    result.createNewFile();
                    result.deleteOnExit();
                    in = binary.getStream();
                    out = new FileOutputStream(result);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    file = result;
                    IOUtils.closeQuietly((InputStream)in);
                }
                catch (IOException e) {
                    this.logger.error("Failed exporting FOP font data.", (Throwable)e);
                    break block6;
                }
                finally {
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly(out);
                    binary.dispose();
                }
                IOUtils.closeQuietly((OutputStream)out);
                binary.dispose();
                return file;
            }
        }
        return null;
    }

    private void deleteFile(File f) {
        if (f != null) {
            File[] children = f.listFiles();
            if (children != null) {
                for (File child : children) {
                    this.deleteFile(child);
                }
            }
            f.delete();
        }
    }

    protected void bindRepo(SlingRepository slingRepository) {
        this.repo = slingRepository;
    }

    protected void unbindRepo(SlingRepository slingRepository) {
        if (this.repo == slingRepository) {
            this.repo = null;
        }
    }
}

