/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.rewriter.xml.fop;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.rewriter.xml.fop.FOPNGSerializer;
import com.day.cq.rewriter.xml.fop.FontConfig;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.rewriter.ProcessingComponentConfiguration;
import org.apache.sling.rewriter.ProcessingContext;
import org.apache.sling.rewriter.Serializer;
import org.apache.sling.rewriter.SerializerFactory;
import org.osgi.service.component.ComponentContext;
import org.xml.sax.SAXException;

public class PersistingFOPNGSerializerFactory
implements SerializerFactory {
    private static final String DEFAULT_STORE_PATH = "/var/dam/docs/documents";
    private static final String PROP_STORE_PATH = "store.path";
    private String storePath;
    private FontConfig fc;

    protected void activate(ComponentContext ctx) {
        this.storePath = OsgiUtil.toString(ctx.getProperties().get(PROP_STORE_PATH), (String)DEFAULT_STORE_PATH);
        if (!this.storePath.endsWith("/")) {
            this.storePath = this.storePath + '/';
        }
    }

    public Serializer createSerializer() {
        PersistingFOPNGSerializer serializer = new PersistingFOPNGSerializer(this.storePath);
        serializer.setFontConfig(this.fc);
        return serializer;
    }

    protected void bindFc(FontConfig fontConfig) {
        this.fc = fontConfig;
    }

    protected void unbindFc(FontConfig fontConfig) {
        if (this.fc == fontConfig) {
            this.fc = null;
        }
    }

    public static final class PersistingFOPNGSerializer
    extends FOPNGSerializer {
        private final String storePath;
        private SlingHttpServletRequest request;
        private String pdfName;
        private static final String PDF_NAME_PARAM = "filename";

        public PersistingFOPNGSerializer(String path) {
            this.storePath = path;
        }

        public void init(ProcessingContext context, ProcessingComponentConfiguration config) throws IOException {
            super.init(context, config);
            this.request = context.getRequest();
            String param = this.request.getParameter(PDF_NAME_PARAM);
            String name = param != null && !"".equals(param) ? param : this.request.getResource().getPath();
            this.pdfName = name.startsWith("/") ? this.storePath + name.substring(1) : this.storePath + name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endDocument() throws SAXException {
            super.endDocument();
            this.logger.debug("Persisting pdf at {}", (Object)this.pdfName);
            Session session = (Session)this.request.getResourceResolver().adaptTo(Session.class);
            if (session != null) {
                ByteArrayInputStream is = null;
                try {
                    JcrUtil.createPath((String)this.pdfName, (boolean)false, (String)"{http://www.jcp.org/jcr/nt/1.0}folder", (String)"{http://www.jcp.org/jcr/nt/1.0}file", (Session)session, (boolean)false);
                    Node content = JcrUtil.createPath((String)(this.pdfName + "/jcr:content"), (boolean)false, (String)"{http://www.jcp.org/jcr/nt/1.0}folder", (String)"{http://www.jcp.org/jcr/nt/1.0}unstructured", (Session)session, (boolean)false);
                    is = new ByteArrayInputStream(this.cachingOS.toByteArray());
                    Binary binary = session.getValueFactory().createBinary((InputStream)is);
                    content.setProperty("jcr:data", binary);
                    content.setProperty("{http://www.jcp.org/jcr/1.0}mimeType", "application/pdf");
                    content.setProperty("{http://www.jcp.org/jcr/1.0}lastModified", Calendar.getInstance());
                    session.save();
                    this.logger.debug("The pdf node has been created at {}" + this.pdfName);
                    IOUtils.closeQuietly((InputStream)is);
                }
                catch (RepositoryException e) {
                    this.logger.error("Error while storing pdf at " + this.pdfName, (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly(is);
                }
            } else {
                this.logger.error("Unable to persist PDF at {} : no session available.", (Object)this.pdfName);
            }
        }
    }
}

