/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.source.factories;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.Map;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.AbstractSource;
import org.apache.excalibur.source.validity.TimeStampValidity;

public class URLSource
extends AbstractSource
implements Source {
    int connectTimeout = -1;
    int readTimeout = -1;
    protected URL m_url;
    protected URLConnection m_connection;
    protected SourceParameters m_parameters;
    protected String m_encoding;
    protected boolean m_isPost = false;
    protected boolean m_exists = false;
    protected SourceValidity m_cachedValidity;
    protected long m_cachedLastModificationDate;
    protected String m_mimeType;

    public void setConnectTimeout(int value) {
        this.connectTimeout = value;
    }

    public void setReadTimeout(int value) {
        this.readTimeout = value;
    }

    public void init(URL url, Map parameters) throws IOException {
        String systemId = url.toExternalForm();
        this.setSystemId(systemId);
        this.setScheme(SourceUtil.getScheme(systemId));
        this.m_url = url;
        this.m_isPost = false;
        try {
            this.m_encoding = System.getProperty("file.property", "ISO-8859-1");
        }
        catch (SecurityException e) {
            this.m_encoding = "ISO-8859-1";
        }
        if (null != parameters) {
            String encoding;
            this.m_parameters = (SourceParameters)parameters.get(SourceResolver.URI_PARAMETERS);
            String method = (String)parameters.get(SourceResolver.METHOD);
            if ("POST".equalsIgnoreCase(method)) {
                this.m_isPost = true;
            }
            if ((encoding = (String)parameters.get(SourceResolver.URI_ENCODING)) != null && !"".equals(encoding)) {
                this.m_encoding = encoding;
            }
        }
        if (null != this.m_parameters && this.m_parameters.hasParameters() && !this.m_isPost) {
            boolean first;
            StringBuffer urlBuffer = new StringBuffer(systemId);
            Iterator i = this.m_parameters.getParameterNames();
            boolean bl = first = systemId.indexOf(63) == -1;
            if (first) {
                urlBuffer.append('?');
            }
            while (i.hasNext()) {
                String key = (String)i.next();
                Iterator values = this.m_parameters.getParameterValues(key);
                while (values.hasNext()) {
                    String value = SourceUtil.encode((String)values.next(), this.m_encoding);
                    if (!first) {
                        urlBuffer.append('&');
                    }
                    first = false;
                    urlBuffer.append(key);
                    urlBuffer.append('=');
                    urlBuffer.append(value);
                }
            }
            this.m_url = new URL(urlBuffer.toString());
            this.m_parameters = null;
        }
    }

    protected void getInfos() {
        block14: {
            this.m_exists = false;
            if (!this.m_isPost) {
                try {
                    if (null == this.m_connection) {
                        this.m_connection = this.m_url.openConnection();
                        String userInfo = this.getUserInfo();
                        if (this.m_url.getProtocol().startsWith("http") && userInfo != null) {
                            this.m_connection.setRequestProperty("Authorization", "Basic " + SourceUtil.encodeBASE64(userInfo));
                        }
                        Class<?> urlConnectionClass = this.m_connection.getClass();
                        try {
                            Method urlConnectionSetConnectTimeoutMethod = urlConnectionClass.getMethod("setConnectTimeout", Integer.TYPE);
                            Method urlConnectionSetReadTimeoutMethod = urlConnectionClass.getMethod("setReadTimeout", Integer.TYPE);
                            if (this.connectTimeout != -1) {
                                urlConnectionSetConnectTimeoutMethod.invoke((Object)this.m_connection, new Integer(this.connectTimeout));
                            }
                            if (this.readTimeout != -1) {
                                urlConnectionSetReadTimeoutMethod.invoke((Object)this.m_connection, new Integer(this.readTimeout));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.setLastModified(this.m_connection.getLastModified());
                    this.m_mimeType = this.m_connection.getContentType();
                    int contentLength = this.m_connection.getContentLength();
                    this.setContentLength(contentLength);
                    if (this.m_connection instanceof HttpURLConnection) {
                        try {
                            int statusCode = ((HttpURLConnection)this.m_connection).getResponseCode();
                            if (statusCode == 200 || statusCode == 304) {
                                this.m_exists = true;
                                break block14;
                            }
                            this.m_exists = false;
                        }
                        catch (IOException ignore) {
                            this.m_exists = false;
                        }
                        break block14;
                    }
                    this.m_exists = contentLength > 0;
                }
                catch (IOException ignore) {
                    super.getInfos();
                }
            } else {
                super.getInfos();
            }
        }
    }

    public boolean exists() {
        this.checkInfos();
        return this.m_exists;
    }

    public InputStream getInputStream() throws IOException, SourceException {
        this.checkInfos();
        InputStream input = null;
        if (this.m_connection == null) {
            this.m_connection = this.m_url.openConnection();
            String userInfo = this.getUserInfo();
            if (this.m_url.getProtocol().startsWith("http") && userInfo != null) {
                this.m_connection.setRequestProperty("Authorization", "Basic " + SourceUtil.encodeBASE64(userInfo));
            }
            if (this.m_connection instanceof HttpURLConnection && this.m_isPost) {
                StringBuffer buffer = new StringBuffer(2000);
                Iterator i = this.m_parameters.getParameterNames();
                boolean first = true;
                while (i.hasNext()) {
                    String key = (String)i.next();
                    Iterator values = this.m_parameters.getParameterValues(key);
                    while (values.hasNext()) {
                        String value = SourceUtil.encode((String)values.next(), this.m_encoding);
                        if (!first) {
                            buffer.append('&');
                        }
                        first = false;
                        buffer.append(key.toString());
                        buffer.append('=');
                        buffer.append(value);
                    }
                }
                HttpURLConnection httpCon = (HttpURLConnection)this.m_connection;
                httpCon.setDoInput(true);
                if (buffer.length() > 1) {
                    String postString = buffer.toString();
                    httpCon.setRequestMethod("POST");
                    httpCon.setDoOutput(true);
                    httpCon.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
                    httpCon.setRequestProperty("Content-length", Integer.toString(postString.length()));
                    BufferedOutputStream out = new BufferedOutputStream(httpCon.getOutputStream());
                    ((OutputStream)out).write(postString.getBytes());
                    ((OutputStream)out).close();
                }
                input = httpCon.getInputStream();
                this.m_connection = null;
                return input;
            }
        }
        input = this.m_connection.getInputStream();
        this.m_connection = null;
        return input;
    }

    public SourceValidity getValidity() {
        long lm = this.getLastModified();
        if (lm > 0L) {
            if (lm == this.m_cachedLastModificationDate) {
                return this.m_cachedValidity;
            }
            this.m_cachedLastModificationDate = lm;
            this.m_cachedValidity = new TimeStampValidity(lm);
            return this.m_cachedValidity;
        }
        return null;
    }

    public void refresh() {
        this.m_connection = null;
        super.refresh();
    }

    public String getMimeType() {
        return this.m_mimeType;
    }

    protected String getUserInfo() {
        if (this.m_url == null) {
            return null;
        }
        String ui = this.m_url.getUserInfo();
        if (ui == null) {
            return null;
        }
        try {
            ui = URLDecoder.decode(ui, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ui;
    }
}

