/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search;

import com.day.cq.search.PredicateGroup;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Predicate
implements Cloneable {
    public static final String PARAM_OFFSET = "offset";
    public static final String PARAM_LIMIT = "limit";
    public static final String PARAM_EXCERPT = "excerpt";
    public static final String ORDER_BY = "orderby";
    public static final String PARAM_SORT = "sort";
    public static final String SORT_ASCENDING = "asc";
    public static final String SORT_DESCENDING = "desc";
    private final String type;
    private String name;
    private PredicateGroup parent;
    private Map<String, String> params = new HashMap<String, String>();
    private boolean ignore = false;

    public Predicate(String type) {
        this.type = type;
    }

    public Predicate(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        if (this.parent != null) {
            String path = this.parent.getPath();
            if (path != null) {
                return path + "." + this.name;
            }
            return this.name;
        }
        if (this.name == null) {
            return null;
        }
        return this.name;
    }

    public String get(String parameterName) {
        return this.params.get(parameterName);
    }

    public String get(String parameterName, String defaultValue) {
        if (this.hasNonEmptyValue(parameterName)) {
            return this.get(parameterName);
        }
        return defaultValue;
    }

    public Predicate set(String parameterName, String value) {
        this.params.put(parameterName, value);
        return this;
    }

    public boolean hasNonEmptyValue(String parameterName) {
        String value = this.get(parameterName);
        return value != null && value.length() > 0;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.params);
    }

    public void setIgnored(boolean ignore) {
        this.ignore = ignore;
    }

    public boolean ignored() {
        return this.ignore;
    }

    public Predicate clone() {
        try {
            Predicate clone = (Predicate)super.clone();
            clone.parent = null;
            clone.params = new HashMap<String, String>();
            for (String key : this.params.keySet()) {
                clone.params.put(key, this.params.get(key));
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    protected void setParent(PredicateGroup parent) {
        this.parent = parent;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getName()).append("=").append(this.getType()).append(": ");
        HashMap<String, String> allParams = new HashMap<String, String>(this.params);
        Iterator keyIter = allParams.keySet().iterator();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            buffer.append(key).append("=").append((String)allParams.get(key));
            if (!keyIter.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }
}

