/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.eval;

import com.day.cq.search.Predicate;
import com.day.cq.search.eval.AbstractPredicateEvaluator;
import com.day.cq.search.eval.EvaluationContext;
import com.day.cq.search.facets.FacetExtractor;
import com.day.cq.search.facets.extractors.DistinctValuesFacetExtractor;

public class JcrPropertyPredicateEvaluator
extends AbstractPredicateEvaluator {
    public static final String PROPERTY = "property";
    public static final String VALUE = "value";
    public static final String OPERATION = "operation";
    public static final String OP_EQUALS = "equals";
    public static final String OP_LIKE = "like";

    public String getXPathExpression(Predicate p, EvaluationContext context) {
        return this.getXPathExpression(p.get(PROPERTY), p.get(VALUE), p.get(OPERATION));
    }

    protected String getXPathExpression(String property, String value, String operation) {
        if (property == null || property.length() == 0 || value == null || value.length() == 0) {
            return null;
        }
        if (OP_EQUALS.equals(operation)) {
            return this.getEqualsExpression(property, value);
        }
        if (OP_LIKE.equals(operation)) {
            return "jcr:like(@" + property + ", '" + value.replaceAll("'", "\\'") + "')";
        }
        return this.getEqualsExpression(property, value);
    }

    private String getEqualsExpression(String property, String value) {
        return "@" + property + " = '" + value.replaceAll("'", "\\'") + "'";
    }

    public String[] getOrderByProperties(Predicate p, EvaluationContext context) {
        return new String[]{p.get(PROPERTY)};
    }

    public FacetExtractor getFacetExtractor(Predicate p, EvaluationContext context) {
        if (p.hasNonEmptyValue(PROPERTY)) {
            Predicate template = p.clone();
            template.set(OPERATION, OP_EQUALS);
            return new DistinctValuesFacetExtractor(p.get(PROPERTY), null, template, VALUE);
        }
        return null;
    }
}

