/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.eval;

import com.day.cq.search.Predicate;
import com.day.cq.search.eval.AbstractPredicateEvaluator;
import com.day.cq.search.eval.EvaluationContext;
import com.day.text.GlobPattern;
import java.util.Comparator;
import javax.jcr.query.Row;
import org.apache.jackrabbit.util.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodenamePredicateEvaluator
extends AbstractPredicateEvaluator {
    public static final String NODENAME = "nodename";

    @Override
    public String getXPathExpression(Predicate p, EvaluationContext context) {
        return null;
    }

    @Override
    public boolean isFiltering(Predicate p, EvaluationContext context) {
        return p.hasNonEmptyValue(NODENAME);
    }

    @Override
    public boolean includes(Predicate p, Row row, EvaluationContext context) {
        if (!p.hasNonEmptyValue(NODENAME)) {
            return true;
        }
        String path = context.getPath(row);
        if (path != null) {
            return GlobPattern.matches((String)p.get(NODENAME), (String)Text.getName((String)path));
        }
        return false;
    }

    @Override
    public Comparator<Row> getOrderByComparator(Predicate predicate, final EvaluationContext context) {
        return new Comparator<Row>(){

            @Override
            public int compare(Row r1, Row r2) {
                String path1 = context.getPath(r1);
                if (path1 == null) {
                    return 0;
                }
                String path2 = context.getPath(r2);
                if (path2 == null) {
                    return 0;
                }
                return Text.getName((String)path1).compareTo(Text.getName((String)path2));
            }
        };
    }
}

