/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.eval;

import com.day.cq.search.Predicate;
import com.day.cq.search.eval.AbstractPredicateEvaluator;
import com.day.cq.search.eval.EvaluationContext;
import com.day.text.GlobPattern;
import java.util.Comparator;
import javax.jcr.query.Row;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathPredicateEvaluator
extends AbstractPredicateEvaluator {
    public static final String PATH = "path";
    public static final String EXACT = "exact";

    @Override
    public String getXPathExpression(Predicate p, EvaluationContext context) {
        return null;
    }

    @Override
    public boolean isFiltering(Predicate p, EvaluationContext context) {
        return p.hasNonEmptyValue(PATH);
    }

    @Override
    public boolean includes(Predicate p, Row row, EvaluationContext context) {
        if (!p.hasNonEmptyValue(PATH)) {
            return true;
        }
        String exactVal = p.get(EXACT);
        boolean exact = "on".equals(exactVal) || "true".equals(exactVal);
        String path = context.getPath(row);
        if (path != null) {
            String pattern = p.get(PATH);
            if (exact) {
                if (pattern.endsWith("/")) {
                    pattern = pattern.substring(0, pattern.length() - 1);
                }
                return path.equals(pattern);
            }
            return GlobPattern.matches((String)pattern.replaceAll("//", "/"), (String)path, (boolean)true);
        }
        return false;
    }

    @Override
    public Comparator<Row> getOrderByComparator(Predicate predicate, final EvaluationContext context) {
        return new Comparator<Row>(){

            @Override
            public int compare(Row r1, Row r2) {
                String path1 = context.getPath(r1);
                if (path1 == null) {
                    return 0;
                }
                String path2 = context.getPath(r2);
                if (path2 == null) {
                    return 0;
                }
                return path1.compareTo(path2);
            }
        };
    }
}

