/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.eval;

import com.day.cq.search.Predicate;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.eval.AbstractPredicateEvaluator;
import com.day.cq.search.eval.EvaluationContext;
import com.day.cq.search.eval.PredicateEvaluator;
import com.day.cq.search.facets.FacetExtractor;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PredicateGroupEvaluator
extends AbstractPredicateEvaluator {
    private static final Logger log = LoggerFactory.getLogger(PredicateGroupEvaluator.class);

    protected String getOpeningBracket() {
        return "(";
    }

    protected String getClosingBracket() {
        return ")";
    }

    public String getXPathExpression(Predicate p, EvaluationContext context) {
        if (!(p instanceof PredicateGroup)) {
            return null;
        }
        PredicateGroup group = (PredicateGroup)p;
        ArrayList<String> expressions = new ArrayList<String>();
        for (Predicate pred : group) {
            String ex;
            PredicateEvaluator evaluator;
            if (pred.ignored() || (evaluator = context.getPredicateEvaluator(pred.getType())) == null || (ex = evaluator.getXPathExpression(pred, context)) == null || ex.length() <= 0) continue;
            expressions.add(ex);
        }
        StringBuffer xpath = new StringBuffer();
        if (expressions.size() > 0) {
            xpath.append(this.getOpeningBracket());
            Iterator exIter = expressions.iterator();
            while (exIter.hasNext()) {
                xpath.append((String)exIter.next());
                if (!exIter.hasNext()) continue;
                if (group.allRequired()) {
                    xpath.append(" and ");
                    continue;
                }
                xpath.append(" or ");
            }
            xpath.append(this.getClosingBracket());
        }
        return xpath.toString();
    }

    public String listFilteringPredicates(PredicateGroup group, EvaluationContext context) {
        StringBuffer result = new StringBuffer();
        for (Predicate p : group) {
            if (p.ignored()) continue;
            if (p instanceof PredicateGroup) {
                if (result.length() > 0) {
                    result.append(", ");
                }
                result.append(this.listFilteringPredicates((PredicateGroup)p, context));
                continue;
            }
            PredicateEvaluator evaluator = context.getPredicateEvaluator(p.getType());
            if (evaluator == null || !evaluator.isFiltering(p, context)) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append("{").append(p.toString()).append("}");
        }
        return result.toString();
    }

    public boolean includes(Predicate predicate, Row row, EvaluationContext context) {
        if (!(predicate instanceof PredicateGroup)) {
            return false;
        }
        PredicateGroup group = (PredicateGroup)predicate;
        if (group.allRequired()) {
            return this.andInclude(group, row, context);
        }
        return this.orInclude(group, row, context);
    }

    private boolean andInclude(PredicateGroup group, Row row, EvaluationContext context) {
        if (group.isEmpty()) {
            return true;
        }
        for (Predicate p : group) {
            PredicateEvaluator evaluator;
            if (p.ignored() || (evaluator = context.getPredicateEvaluator(p.getType())) == null || evaluator.includes(p, row, context)) continue;
            try {
                log.debug("predicate " + p.getName() + " (" + p.getType() + ") denied row " + row.getValue("jcr:path").getString());
            }
            catch (RepositoryException e) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    private boolean orInclude(PredicateGroup group, Row row, EvaluationContext context) {
        int predicatesAsked = 0;
        for (Predicate p : group) {
            PredicateEvaluator evaluator;
            if (p.ignored() || (evaluator = context.getPredicateEvaluator(p.getType())) == null || !evaluator.isFiltering(p, context)) continue;
            if (evaluator.includes(p, row, context)) {
                return true;
            }
            ++predicatesAsked;
        }
        if (predicatesAsked == 0) {
            return true;
        }
        try {
            log.debug("no predicate in group " + group.getName() + " accepted row " + row.getValue("jcr:path").getString());
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        return false;
    }

    public FacetExtractor getFacetExtractor(Predicate predicate, EvaluationContext context) {
        return null;
    }
}

