/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.eval;

import com.day.cq.search.Predicate;
import com.day.cq.search.eval.AbstractPredicateEvaluator;
import com.day.cq.search.eval.EvaluationContext;

public class RangePropertyPredicateEvaluator
extends AbstractPredicateEvaluator {
    public static final String PROPERTY = "property";
    public static final String LOWER_BOUND = "lowerBound";
    public static final String LOWER_OPERATION = "lowerOperation";
    public static final String UPPER_BOUND = "upperBound";
    public static final String UPPER_OPERATION = "upperOperation";

    public String getXPathExpression(Predicate p, EvaluationContext context) {
        return this.getXPathExpression(p.get(PROPERTY), p.get(LOWER_BOUND), p.get(LOWER_OPERATION), p.get(UPPER_BOUND), p.get(UPPER_OPERATION));
    }

    protected String getXPathExpression(String property, String lowerValue, String lowerOperation, String upperValue, String upperOperation) {
        String op;
        if (property == null || property.length() == 0 || (lowerValue == null || lowerValue.length() == 0) && (upperValue == null || upperValue.length() == 0)) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        if (lowerValue != null) {
            op = lowerOperation;
            if (!">".equals(op) && !">=".equals(op)) {
                op = ">";
            }
            buffer.append("@").append(property).append(" ").append(op).append(" ").append(lowerValue);
        }
        if (upperValue != null) {
            if (buffer.length() > 1) {
                buffer.append(" and ");
            }
            if (!"<".equals(op = upperOperation) && !"<=".equals(op)) {
                op = "<";
            }
            buffer.append("@").append(property).append(" ").append(op).append(" ").append(upperValue);
        }
        buffer.append(")");
        return buffer.toString();
    }

    public String[] getOrderByProperties(Predicate p, EvaluationContext context) {
        return new String[]{p.get(PROPERTY)};
    }
}

