/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.eval;

import com.day.cq.search.Predicate;
import com.day.cq.search.eval.AbstractPredicateEvaluator;
import com.day.cq.search.eval.EvaluationContext;
import com.day.cq.search.facets.FacetExtractor;
import com.day.cq.search.facets.extractors.DistinctValuesFacetExtractor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypePredicateEvaluator
extends AbstractPredicateEvaluator {
    private static final Logger log = LoggerFactory.getLogger(TypePredicateEvaluator.class);
    public static final String TYPE = "type";

    @Override
    public String getXPathExpression(Predicate p, EvaluationContext context) {
        if (!p.hasNonEmptyValue(TYPE)) {
            return null;
        }
        String typeName = p.get(TYPE);
        ArrayList<NodeType> searchNodeTypes = new ArrayList<NodeType>();
        try {
            NodeType nodeType;
            NodeTypeManager nodeTypeManager = context.getSession().getWorkspace().getNodeTypeManager();
            try {
                nodeType = nodeTypeManager.getNodeType(typeName);
            }
            catch (NoSuchNodeTypeException ne) {
                log.warn("node type '" + typeName + "' not found");
                return null;
            }
            searchNodeTypes.add(nodeType);
            searchNodeTypes.addAll(this.getDescendentNodeTypes(nodeType, nodeTypeManager));
        }
        catch (RepositoryException e) {
            log.debug("could not find child node types for '" + typeName + "'", (Throwable)e);
        }
        StringBuffer xpath = new StringBuffer();
        xpath.append("(");
        for (NodeType nt : searchNodeTypes) {
            if (xpath.length() > 1) {
                xpath.append(" or ");
            }
            if (nt.isMixin()) {
                xpath.append("@").append("jcr:mixinTypes");
            } else {
                xpath.append("@").append("jcr:primaryType");
            }
            xpath.append(" = '").append(nt.getName()).append("'");
        }
        xpath.append(")");
        return xpath.toString();
    }

    @Override
    public String[] getOrderByProperties(Predicate p, EvaluationContext context) {
        return new String[]{"jcr:primaryType", "jcr:mixinTypes"};
    }

    @Override
    public FacetExtractor getFacetExtractor(Predicate predicate, EvaluationContext context) {
        return new DistinctValuesFacetExtractor("jcr:primaryType", null, predicate.clone(), TYPE);
    }

    protected List<NodeType> getDescendentNodeTypes(NodeType nodeType, NodeTypeManager nodeTypeManager) throws RepositoryException {
        ArrayList<NodeType> childNodeTypes = new ArrayList<NodeType>();
        NodeTypeIterator allTypes = nodeTypeManager.getAllNodeTypes();
        while (allTypes.hasNext()) {
            NodeType nt = allTypes.nextNodeType();
            if (!Arrays.asList(nt.getSupertypes()).contains(nodeType)) continue;
            childNodeTypes.add(nt);
        }
        return childNodeTypes;
    }
}

