/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.facets.extractors;

import com.day.cq.search.facets.Facet;
import com.day.cq.search.facets.buckets.PredefinedBucket;
import com.day.cq.search.facets.extractors.FacetImpl;
import com.day.cq.search.facets.extractors.PropertyFacetExtractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredefinedBucketsFacetExtractor
extends PropertyFacetExtractor {
    private List<PredefinedBucket> buckets = new ArrayList<PredefinedBucket>();
    private Facet facet = null;

    public PredefinedBucketsFacetExtractor(String propertyRelPath) {
        super(propertyRelPath);
    }

    public PredefinedBucketsFacetExtractor(String propertyRelPath, Collection<? extends PredefinedBucket> buckets) {
        super(propertyRelPath);
        this.buckets.addAll(buckets);
    }

    public void addPredefinedBucket(PredefinedBucket bucket) {
        this.buckets.add(bucket);
    }

    @Override
    protected void handleValue(Value value) throws RepositoryException {
        for (PredefinedBucket bucket : this.buckets) {
            bucket.acceptValue(value);
        }
    }

    @Override
    public Facet getFacet() {
        if (this.facet == null) {
            if (this.buckets == null) {
                return null;
            }
            Iterator<PredefinedBucket> it = this.buckets.iterator();
            while (it.hasNext()) {
                if (it.next().getCount() != 0L) continue;
                it.remove();
            }
            this.facet = new FacetImpl(this.buckets);
        }
        return this.facet;
    }

    @Override
    protected List<Value> filter(List<Value> values, ValueFactory vf) throws RepositoryException {
        return values;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PredefinedBucketsFacetExtractor other = (PredefinedBucketsFacetExtractor)obj;
        if (this.propertyRelPath != other.propertyRelPath && !this.propertyRelPath.equals(other.propertyRelPath)) {
            return false;
        }
        return this.buckets == other.buckets || ((Object)this.buckets).equals(other.buckets);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.propertyRelPath == null ? 0 : this.propertyRelPath.hashCode());
        hash = 31 * hash + (this.buckets == null ? 0 : ((Object)this.buckets).hashCode());
        return hash;
    }
}

