/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.impl.builder;

import com.day.cq.search.eval.EvaluationContext;
import com.day.cq.search.eval.PredicateEvaluator;
import com.day.cq.search.impl.builder.QueryImpl;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Row;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluationContextImpl
implements EvaluationContext {
    private static final Logger log = LoggerFactory.getLogger(EvaluationContextImpl.class);
    private QueryImpl query;

    public EvaluationContextImpl(QueryImpl query) {
        this.query = query;
    }

    public PredicateEvaluator getPredicateEvaluator(String type) {
        return this.query.getPredicateEvaluator(type);
    }

    public Session getSession() {
        return this.query.getSession();
    }

    public Node getNode(Row row) {
        try {
            Value value = row.getValue("jcr:path");
            if (value != null) {
                String path = value.getString();
                return (Node)this.getSession().getItem(path);
            }
        }
        catch (RepositoryException e) {
            log.warn("Could not retrive jcr:path value from row", (Throwable)e);
        }
        return null;
    }

    public ResourceResolver getResourceResolver() {
        return this.query.getResourceResolver();
    }

    public String getPath(Row row) {
        try {
            Value value = row.getValue("jcr:path");
            if (value != null) {
                return value.getString();
            }
        }
        catch (RepositoryException e) {
            log.warn("Could not retrive jcr:path value from row", (Throwable)e);
        }
        return null;
    }

    public Resource getResource(Row row) {
        return this.getResourceResolver().resolve(this.getPath(row));
    }
}

