/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.impl.builder;

import com.day.cq.search.Predicate;
import com.day.cq.search.PredicateGroup;
import java.util.ArrayList;
import java.util.List;

public abstract class PredicateWalker {
    public void visit(Predicate predicate) {
        if (predicate instanceof PredicateGroup) {
            this.visit((PredicateGroup)predicate);
        } else {
            this.visitInternal(predicate);
        }
    }

    public void visit(PredicateGroup group) {
        this.visitInternal(group);
        for (Predicate p : group) {
            this.visit(p);
        }
    }

    protected abstract void visitInternal(Predicate var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExtractByType
    extends PredicateWalker {
        private String type;
        protected List<Predicate> predicatesFound = new ArrayList<Predicate>();

        public static List<Predicate> find(Predicate predicate, String type) {
            ExtractByType walker = new ExtractByType(type);
            walker.visit(predicate);
            return walker.getFoundPredicates();
        }

        public ExtractByType(String type) {
            this.type = type;
        }

        @Override
        protected void visitInternal(Predicate predicate) {
            if (this.type.equals(predicate.getType())) {
                this.predicatesFound.add(predicate);
            }
        }

        public List<Predicate> getFoundPredicates() {
            return this.predicatesFound;
        }
    }
}

