/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.impl.builder;

import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.impl.builder.QueryImpl;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.Session;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryBuilderImpl
implements QueryBuilder {
    private static final Logger log = LoggerFactory.getLogger(QueryBuilderImpl.class);
    private Map<Object, ServiceReference> refMap = new HashMap<Object, ServiceReference>();
    private Map<Object, ComponentInstance> instanceMap = new HashMap<Object, ComponentInstance>();
    private JcrResourceResolverFactory jcrResourceResolverFactory;
    private BundleContext bundleContext;
    private static final String EXCERPT_PROPERTIES = "excerpt.properties";
    private Set<String> excerptProperties;

    @Override
    public Query createQuery(Session session) {
        return this.createQuery(new PredicateGroup(), session);
    }

    @Override
    public Query createQuery(PredicateGroup predicates, Session session) {
        return new QueryImpl(predicates, session, this);
    }

    public ResourceResolver createResourceResolver(Session session) {
        return this.jcrResourceResolverFactory.getResourceResolver(session);
    }

    public Set<String> getExcerptPropertyNames() {
        return this.excerptProperties;
    }

    protected void activate(ComponentContext context) {
        String[] excerptProps;
        this.bundleContext = context.getBundleContext();
        this.excerptProperties = new HashSet<String>();
        for (String prop : excerptProps = (String[])context.getProperties().get(EXCERPT_PROPERTIES)) {
            if (prop == null || prop.trim().length() <= 0) continue;
            this.excerptProperties.add(prop);
        }
    }

    protected void deactivate(ComponentContext context) {
        this.bundleContext = null;
        this.excerptProperties = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ComponentT> ComponentT getComponent(Class<ComponentT> typeClass, String type, Dictionary properties) {
        ServiceReference[] refs = null;
        try {
            refs = this.bundleContext.getServiceReferences(ComponentFactory.class.getName(), "(component.factory=" + typeClass.getName() + '/' + type + ')');
        }
        catch (InvalidSyntaxException e) {
            log.error("Unable to get " + typeClass.getSimpleName() + " instance: " + type, (Throwable)e);
            return null;
        }
        if (refs == null || refs.length == 0) {
            return null;
        }
        ServiceReference ref = refs[0];
        ComponentFactory factory = (ComponentFactory)this.bundleContext.getService(ref);
        ComponentInstance instance = factory.newInstance(properties);
        Object component = instance.getInstance();
        if (component == null) {
            log.error("Unable to get " + typeClass.getSimpleName() + " instance: " + type);
            instance.dispose();
            this.bundleContext.ungetService(ref);
        } else {
            Map<Object, ServiceReference> map = this.refMap;
            synchronized (map) {
                this.refMap.put(component, ref);
                this.instanceMap.put(component, instance);
            }
        }
        return (ComponentT)component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseComponent(Object component) {
        Map<Object, ServiceReference> map = this.refMap;
        synchronized (map) {
            if (this.instanceMap.containsKey(component)) {
                this.instanceMap.get(component).dispose();
                this.instanceMap.remove(component);
            }
            if (this.refMap.containsKey(component)) {
                this.bundleContext.ungetService(this.refMap.get(component));
                this.refMap.remove(component);
            }
        }
    }

    protected void bindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.jcrResourceResolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.jcrResourceResolverFactory == jcrResourceResolverFactory) {
            this.jcrResourceResolverFactory = null;
        }
    }
}

