/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.impl.builder;

import com.day.cq.search.Predicate;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.eval.EvaluationContext;
import com.day.cq.search.eval.PredicateEvaluator;
import com.day.cq.search.facets.Bucket;
import com.day.cq.search.facets.Facet;
import com.day.cq.search.facets.FacetExtractor;
import com.day.cq.search.impl.builder.EmptyQueryResult;
import com.day.cq.search.impl.builder.EvaluationContextImpl;
import com.day.cq.search.impl.builder.PropertyComparator;
import com.day.cq.search.impl.builder.QueryBuilderImpl;
import com.day.cq.search.impl.builder.RootEvaluator;
import com.day.cq.search.impl.result.SearchResultImpl;
import com.day.cq.search.result.SearchResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.jackrabbit.commons.iterator.RowIteratorAdapter;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryImpl
implements Query {
    private static final Logger log = LoggerFactory.getLogger(QueryImpl.class);
    private final Session session;
    private final QueryBuilderImpl queryBuilder;
    private final PredicateGroup rootPredicate;
    private SearchResultImpl result;
    private QueryResult rawQueryResult;
    private ResourceResolver resourceResolver;
    private List<Row> realResultRows;
    private Map<String, PredicateEvaluator> evaluators = new HashMap<String, PredicateEvaluator>();
    private String xpath;
    private String filteringPredicates;
    private Map<FacetExtractor, List<Predicate>> facetExtractors;

    public QueryImpl(PredicateGroup rootPredicate, Session session, QueryBuilderImpl queryBuilder) {
        this.rootPredicate = rootPredicate;
        this.session = session;
        this.queryBuilder = queryBuilder;
    }

    @Override
    public SearchResult getResult() {
        if (this.result == null) {
            this.result = this.execute();
        }
        return this.result;
    }

    @Override
    public PredicateGroup getPredicates() {
        return this.rootPredicate;
    }

    @Override
    public void registerPredicateEvaluator(String type, PredicateEvaluator evaluator) {
        if (type != null && type.length() > 0 && evaluator != null) {
            this.evaluators.put(type, evaluator);
        }
    }

    @Override
    public Query refine(Bucket bucket) {
        Predicate predicate = bucket.getPredicate().clone();
        PredicateGroup root = this.rootPredicate.clone();
        predicate.setName(predicate.getType());
        if (root.allRequired()) {
            if (root.getByName(predicate.getName()) != null) {
                predicate.setName(this.findUniqueName(predicate.getType(), root));
            }
            root.add(predicate);
        } else {
            PredicateGroup newRoot = new PredicateGroup();
            newRoot.setAllRequired(true);
            newRoot.add(root);
            newRoot.add(predicate);
            root.setName(this.findUniqueName("group", newRoot));
            root = newRoot;
        }
        return new QueryImpl(root, this.session, this.queryBuilder);
    }

    @Override
    public void setExcerpt(boolean excerpt) {
        RootEvaluator.setExcerpt(this.rootPredicate, excerpt);
    }

    @Override
    public boolean getExcerpt() {
        return RootEvaluator.isExcerpt(this.rootPredicate);
    }

    @Override
    public long getStart() {
        try {
            return Long.parseLong(this.rootPredicate.get("offset", "0"));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Override
    public void setStart(long start) {
        if (start < 0L) {
            this.rootPredicate.set("offset", "0");
        } else {
            this.rootPredicate.set("offset", Long.toString(start));
        }
    }

    @Override
    public long getHitsPerPage() {
        try {
            return Long.parseLong(this.rootPredicate.get("limit", "10"));
        }
        catch (NumberFormatException e) {
            return 10L;
        }
    }

    @Override
    public void setHitsPerPage(long hitsPerPage) {
        if (hitsPerPage < 0L) {
            this.rootPredicate.set("limit", "10");
        } else {
            this.rootPredicate.set("limit", Long.toString(hitsPerPage));
        }
    }

    public Session getSession() {
        return this.session;
    }

    public ResourceResolver getResourceResolver() {
        if (this.resourceResolver == null) {
            this.resourceResolver = this.queryBuilder.createResourceResolver(this.session);
        }
        return this.resourceResolver;
    }

    public PredicateEvaluator getPredicateEvaluator(String type) {
        if ("orderby".equals(type)) {
            return null;
        }
        if (this.evaluators.containsKey(type)) {
            return this.evaluators.get(type);
        }
        PredicateEvaluator evaluator = this.queryBuilder.getComponent(PredicateEvaluator.class, type, null);
        if (evaluator == null) {
            log.warn("no PredicateEvaluator found for '" + type + "'");
        }
        this.evaluators.put(type, evaluator);
        return evaluator;
    }

    private void releasePredicateEvaluators() {
        for (PredicateEvaluator pe : this.evaluators.values()) {
            this.queryBuilder.releaseComponent(pe);
        }
        this.evaluators.clear();
    }

    public Set<String> getExcerptPropertyNames() {
        return this.queryBuilder.getExcerptPropertyNames();
    }

    public QueryResult getRawQueryResult() {
        if (this.rawQueryResult == null) {
            this.getResult();
        }
        return this.rawQueryResult;
    }

    public Map<String, Facet> extractFacets() {
        List<Predicate> predicates;
        if (this.facetExtractors == null) {
            throw new IllegalStateException("Query.getFacets() can only called after a successful call to getResult()");
        }
        HashMap<String, Facet> facets = new HashMap<String, Facet>();
        if (this.facetExtractors.size() == 0) {
            return facets;
        }
        if (log.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            for (FacetExtractor facetExtractor : this.facetExtractors.keySet()) {
                buffer.append(facetExtractor).append(" => {\n");
                predicates = this.facetExtractors.get(facetExtractor);
                for (Predicate p : predicates) {
                    buffer.append("    ").append(p.getPath()).append("\n");
                }
                buffer.append("}\n");
            }
            log.debug("facet extractors:\n" + buffer.toString());
        }
        log.debug("extracting facets...");
        Iterator<Row> rowIter = this.realResultRows.iterator();
        try {
            while (rowIter.hasNext()) {
                String path = rowIter.next().getValue("jcr:path").getString();
                Node node = (Node)this.session.getItem(path);
                if (node == null) continue;
                for (FacetExtractor extractor : this.facetExtractors.keySet()) {
                    extractor.handleNode(node);
                }
            }
        }
        catch (RepositoryException e) {
            log.error("Could not extract facets for search result", (Throwable)e);
        }
        log.debug("extracting facets done");
        for (FacetExtractor facetExtractor : this.facetExtractors.keySet()) {
            predicates = this.facetExtractors.get(facetExtractor);
            Facet facet = facetExtractor.getFacet();
            if (facet == null) continue;
            for (Predicate p : predicates) {
                facets.put(p.getPath(), facet);
            }
        }
        return facets;
    }

    public String getStatement() {
        return this.xpath;
    }

    public String getFilteringPredicates() {
        return this.filteringPredicates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SearchResultImpl execute() {
        RowIterator rowIter;
        if (log.isDebugEnabled()) {
            log.debug("executing query (URL): " + this.rootPredicate.toURL());
        }
        log.info("executing query (predicate tree):\n" + this.rootPredicate.toString());
        long time = System.currentTimeMillis();
        RootEvaluator rootEvaluator = new RootEvaluator();
        EvaluationContextImpl context = new EvaluationContextImpl(this);
        List<Comparator<Row>> comparators = this.extractOrderByPredicates(rootEvaluator, context);
        try {
            try {
                this.xpath = rootEvaluator.getXPathExpression(this.rootPredicate, context);
                log.info("XPath query: " + this.xpath);
                QueryManager qm = this.session.getWorkspace().getQueryManager();
                this.rawQueryResult = qm.createQuery(this.xpath, "xpath").execute();
                log.debug("xpath query done");
            }
            catch (RepositoryException e) {
                log.warn("Could not run xpath query", (Throwable)e);
                this.rawQueryResult = EmptyQueryResult.INSTANCE;
            }
            this.filteringPredicates = rootEvaluator.listFilteringPredicates(this.rootPredicate, context);
            if (this.filteringPredicates.length() > 0) {
                log.info("filtering predicates: " + this.filteringPredicates);
            } else {
                log.info("no filtering predicates");
            }
            log.debug("filtering result set...");
            this.realResultRows = new ArrayList<Row>();
            rowIter = this.rawQueryResult.getRows();
            while (rowIter.hasNext()) {
                Row row = rowIter.nextRow();
                if (!rootEvaluator.includes(this.rootPredicate, row, context)) continue;
                this.realResultRows.add(row);
            }
            log.debug("filtering result set done");
            if (comparators != null) {
                log.debug("sorting result set...");
                Comparator chain = ComparatorUtils.chainedComparator(comparators);
                Collections.sort(this.realResultRows, chain);
                log.debug("sorting result set done");
            }
            rowIter = new RowIteratorAdapter(this.realResultRows);
            this.facetExtractors = new HashMap<FacetExtractor, List<Predicate>>();
            this.collectFacetExtractors(this.rootPredicate, this.facetExtractors, context);
        }
        catch (RepositoryException e) {
            log.warn("Could not execute xpath query", (Throwable)e);
            rowIter = RowIteratorAdapter.EMPTY;
        }
        finally {
            rootEvaluator.cleanup();
            this.resetOrderByPredicates();
            this.releasePredicateEvaluators();
        }
        time = System.currentTimeMillis() - time;
        log.info("query execution took " + time + " ms");
        return new SearchResultImpl(this, rowIter, time, this.getStart(), this.getHitsPerPage());
    }

    private List<Comparator<Row>> extractOrderByPredicates(RootEvaluator rootEvaluator, EvaluationContext context) {
        ArrayList<Comparator<Row>> comparators = new ArrayList<Comparator<Row>>();
        boolean atLeastOneCustomComparator = false;
        for (Predicate p : this.rootPredicate) {
            Comparator<Row> customComparator;
            if (!"orderby".equals(p.getType()) || !p.hasNonEmptyValue("orderby")) continue;
            p.setIgnored(true);
            String orderBy = p.get("orderby");
            boolean ascending = p.get("sort", "asc").equals("asc");
            boolean useIndex = "true".equals(p.get("index"));
            if (orderBy.startsWith("@")) {
                if (!this.handleOrderBy(orderBy.substring(1), ascending, useIndex, comparators, context, rootEvaluator)) continue;
                atLeastOneCustomComparator = true;
                continue;
            }
            Predicate predForOrder = this.rootPredicate.getByPath(orderBy);
            PredicateEvaluator pe = predForOrder != null ? context.getPredicateEvaluator(predForOrder.getType()) : context.getPredicateEvaluator(orderBy);
            if (pe == null) {
                log.warn("predicate referenced by orderby-predicate not found: " + orderBy);
                continue;
            }
            if (pe == null) continue;
            String[] props = pe.getOrderByProperties(predForOrder, context);
            if (props != null) {
                for (String prop : props) {
                    if (!this.handleOrderBy(prop, ascending, useIndex, comparators, context, rootEvaluator)) continue;
                    atLeastOneCustomComparator = true;
                }
            }
            if ((customComparator = pe.getOrderByComparator(predForOrder, context)) == null) continue;
            atLeastOneCustomComparator = true;
            log.info("custom order by comparator: " + orderBy);
            comparators.add(this.getComparator(customComparator, ascending));
        }
        if (atLeastOneCustomComparator) {
            return comparators;
        }
        return null;
    }

    private boolean handleOrderBy(String property, boolean ascending, boolean useIndex, List<Comparator<Row>> comparators, EvaluationContext context, RootEvaluator rootEvaluator) {
        boolean customComparator = false;
        if (property.contains("/")) {
            if (useIndex) {
                String path = property.replaceAll("/", "_");
                path = path.replaceAll(":", "_");
                rootEvaluator.addOrderBySpec(path, ascending);
            } else {
                customComparator = true;
                log.info("custom order by comparator: " + property);
            }
        } else {
            rootEvaluator.addOrderBySpec(property, ascending);
        }
        comparators.add(this.getComparator(new PropertyComparator(property, context), ascending));
        return customComparator;
    }

    private Comparator<Row> getComparator(Comparator<Row> c, boolean ascending) {
        if (ascending) {
            return c;
        }
        return Collections.reverseOrder(c);
    }

    private void resetOrderByPredicates() {
        for (Predicate p : this.rootPredicate) {
            if (!"orderby".equals(p.getType()) || !p.hasNonEmptyValue("orderby")) continue;
            p.setIgnored(false);
        }
    }

    private void collectFacetExtractors(Predicate predicate, Map<FacetExtractor, List<Predicate>> extractors, EvaluationContext context) {
        if (predicate instanceof PredicateGroup) {
            PredicateGroup group = (PredicateGroup)predicate;
            for (Predicate child : group) {
                this.collectFacetExtractors(child, extractors, context);
            }
        } else {
            FacetExtractor extractor;
            PredicateEvaluator evaluator = this.getPredicateEvaluator(predicate.getType());
            if (evaluator != null && (extractor = evaluator.getFacetExtractor(predicate, context)) != null) {
                if (extractors.containsKey(extractor)) {
                    extractors.get(extractor).add(predicate);
                } else {
                    ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                    predicates.add(predicate);
                    extractors.put(extractor, predicates);
                }
            }
        }
    }

    private String findUniqueName(String baseName, PredicateGroup target) {
        String newName;
        int count = target.size();
        while (target.getByName(newName = ++count + "_" + baseName) != null) {
        }
        return baseName;
    }
}

