/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.impl.builder;

import com.day.cq.search.Predicate;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.eval.EvaluationContext;
import com.day.cq.search.eval.PredicateGroupEvaluator;
import java.util.ArrayList;
import java.util.List;

public class RootEvaluator
extends PredicateGroupEvaluator {
    private Predicate pathPredicate;
    private Predicate typePredicate;
    private List<OrderBySpec> orderBySpecs = new ArrayList<OrderBySpec>();

    protected String getOpeningBracket() {
        return "[";
    }

    protected String getClosingBracket() {
        return "]";
    }

    public static boolean isExcerpt(Predicate rootPredicate) {
        String value = rootPredicate.get("excerpt");
        return "true".equals(value) || "on".equals(value);
    }

    public static void setExcerpt(Predicate rootPredicate, boolean excerpt) {
        rootPredicate.set("excerpt", excerpt ? "true" : "false");
    }

    public void addOrderBySpec(String property, boolean ascending) {
        this.orderBySpecs.add(new OrderBySpec(property, ascending));
    }

    public String getXPathExpression(Predicate predicate, EvaluationContext context) {
        StringBuffer xpath = new StringBuffer();
        PredicateGroup group = (PredicateGroup)predicate;
        if (group.size() == 1 || group.allRequired()) {
            for (Predicate p : group) {
                if (!"path".equals(p.getType()) || !p.hasNonEmptyValue("path") || !p.get("path").startsWith("/")) continue;
                this.pathPredicate = p;
                this.pathPredicate.setIgnored(true);
                break;
            }
        }
        if (group.size() == 1 || group.allRequired()) {
            for (Predicate p : group) {
                if (!"type".equals(p.getType()) || !p.hasNonEmptyValue("type")) continue;
                this.typePredicate = p;
                this.typePredicate.setIgnored(true);
                break;
            }
        }
        if (this.pathPredicate != null) {
            xpath.append("/jcr:root").append(this.pathPredicate.get("path"));
            if (!"on".equals(this.pathPredicate.get("exact"))) {
                if (xpath.charAt(xpath.length() - 1) == '/') {
                    xpath.append("/*");
                } else {
                    xpath.append("//*");
                }
            }
        } else {
            xpath.append("//*");
        }
        if (this.typePredicate != null) {
            String typeConstraint = "element(*, " + this.typePredicate.get("type") + ")";
            int end = xpath.length() - 1;
            if (xpath.charAt(end) == '*') {
                xpath.replace(end, end + 1, typeConstraint);
            } else if (xpath.charAt(end) != '/') {
                xpath.append("/").append(typeConstraint);
            } else {
                xpath.append(typeConstraint);
            }
        }
        xpath.append(super.getXPathExpression(predicate, context));
        if (RootEvaluator.isExcerpt(group)) {
            xpath.append("/rep:excerpt(.)");
        }
        if (this.orderBySpecs.size() > 0) {
            xpath.append(" order by ");
            int count = 0;
            for (OrderBySpec obs : this.orderBySpecs) {
                if (count > 0) {
                    xpath.append(", ");
                }
                xpath.append(obs.getOrderByForXPath());
                ++count;
            }
        }
        return xpath.toString();
    }

    public void cleanup() {
        if (this.pathPredicate != null) {
            this.pathPredicate.setIgnored(false);
        }
        if (this.typePredicate != null) {
            this.typePredicate.setIgnored(false);
        }
    }

    private static class OrderBySpec {
        public String property;
        public boolean ascending;

        public OrderBySpec(String property, boolean ascending) {
            this.property = property;
            this.ascending = ascending;
        }

        public String getOrderByForXPath() {
            return "@" + this.property + (this.ascending ? "" : " descending");
        }
    }
}

