/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.impl.misc;

import com.day.cq.search.impl.result.HitImpl;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Set;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Row;
import javax.jcr.util.TraversingItemVisitor;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class Excerpt {
    private static final HTML.Tag HIGHLIGHT_TAG = HTML.Tag.STRONG;
    private static final int HIGHLIGHT_OFFSET = HIGHLIGHT_TAG.toString().length() * 2 + 5;
    private final String text;
    private final boolean hasHighlights;

    private Excerpt(String text, boolean hasHighlights) {
        this.text = text;
        this.hasHighlights = hasHighlights;
    }

    private Excerpt(String text) {
        this(text, false);
    }

    public static Excerpt create(final HitImpl hit, final Set excerptPropNames, final int maxLength) throws RepositoryException {
        ArrayList excerpt;
        block5: {
            Node node = (Node)hit.getResource().adaptTo(Node.class);
            if (node == null || !node.hasNode("jcr:content")) {
                return new Excerpt(hit.getExcerpts().get("."));
            }
            Node content = node.getNode("jcr:content");
            if (content.isNodeType("nt:resource")) {
                return new Excerpt(hit.getExcerpts().get("."));
            }
            excerpt = new ArrayList();
            final int prefixLength = node.getPath().length() + 1;
            try {
                content.accept((ItemVisitor)new TraversingItemVisitor.Default(true){

                    protected void entering(Property property, int level) throws RepositoryException {
                        if (!excerptPropNames.contains(property.getName())) {
                            return;
                        }
                        String relPath = property.getPath().substring(prefixLength);
                        Excerpt e = Excerpt.createExcerpt(property, relPath, hit.getRow(), maxLength);
                        if (e == null) {
                            return;
                        }
                        if (e.hasHighlights) {
                            excerpt.clear();
                            excerpt.add(e);
                            throw new RepositoryException();
                        }
                        if (excerpt.size() == 0) {
                            excerpt.add(e);
                        }
                    }
                });
            }
            catch (RepositoryException e) {
                if (excerpt.size() != 0) break block5;
                throw e;
            }
        }
        if (excerpt.size() == 0) {
            return new Excerpt("");
        }
        return (Excerpt)excerpt.get(0);
    }

    public String getText() {
        return this.text;
    }

    public static String getFirstSpan(String excerpt) {
        int end;
        int start = excerpt.indexOf("<span>");
        if (start != -1 && (end = excerpt.indexOf("</span>", start)) != -1) {
            return excerpt.substring(start + "<span>".length(), end);
        }
        return excerpt;
    }

    private static Excerpt createExcerpt(Property property, String relPath, Row row, final int maxLength) throws RepositoryException {
        if (property.getLength() == 0L) {
            return null;
        }
        Value v = row.getValue("rep:excerpt(" + relPath + ")");
        if (v == null) {
            return null;
        }
        final int[] numHighlights = new int[]{0};
        final StringBuffer text = new StringBuffer();
        HTMLEditorKit.Parser parser = HTMLParser.getInstance();
        try {
            parser.parse(new StringReader(Excerpt.getFirstSpan(v.getString())), new HTMLEditorKit.ParserCallback(){
                private boolean highlighted = false;
                private boolean complete = false;

                public void handleText(char[] data, int pos) {
                    if (this.complete) {
                        return;
                    }
                    text.append(this.stripTags(new String(data)));
                    if (!this.highlighted && text.length() > this.getMaxLength()) {
                        if (numHighlights[0] > 0) {
                            for (int i = this.getMaxLength(); i >= 0; --i) {
                                if (!Character.isWhitespace(text.charAt(i))) continue;
                                text.setLength(i + 1);
                                text.append("...");
                                break;
                            }
                            this.complete = true;
                        } else {
                            for (int i = text.length() - this.getMaxLength() / 3; i >= 0; --i) {
                                if (!Character.isWhitespace(text.charAt(i))) continue;
                                text.delete(0, i + 1);
                                break;
                            }
                        }
                    }
                }

                public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                    if (this.complete) {
                        return;
                    }
                    if (t == HIGHLIGHT_TAG) {
                        text.append("<");
                        text.append(t.toString());
                        text.append(">");
                        this.highlighted = true;
                        numHighlights[0] = numHighlights[0] + 1;
                    }
                }

                public void handleEndTag(HTML.Tag t, int pos) {
                    if (this.complete) {
                        return;
                    }
                    if (t == HIGHLIGHT_TAG) {
                        text.append("</");
                        text.append(t.toString());
                        text.append(">");
                        this.highlighted = false;
                    }
                }

                private int getMaxLength() {
                    return maxLength + numHighlights[0] * HIGHLIGHT_OFFSET;
                }

                private String stripTags(String text2) {
                    if (text2.indexOf(60) != -1) {
                        try {
                            HTMLEditorKit htmlKit = new HTMLEditorKit();
                            HTMLDocument doc = new HTMLDocument();
                            htmlKit.read(new StringReader(text2), (Document)doc, 0);
                            return doc.getText(0, doc.getLength());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return text2;
                }
            }, true);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        return new Excerpt(text.toString(), numHighlights[0] > 0);
    }

    private static final class HTMLParser
    extends HTMLEditorKit {
        private static final long serialVersionUID = 383121295616881915L;
        private static final HTMLParser INSTANCE = new HTMLParser();

        private HTMLParser() {
        }

        public static HTMLEditorKit.Parser getInstance() {
            return INSTANCE.getParser();
        }
    }
}

