/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.impl.misc;

import com.day.cq.search.Trends;
import com.day.cq.statistics.StatisticsService;
import com.day.crx.statistics.Report;
import com.day.crx.statistics.query.MostPopularQueriesReport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.jcr.RepositoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrendsImpl
implements Trends {
    private final StatisticsService statService;
    private int minSize = 12;
    private int maxSize = 18;
    private int maxQueries = 20;

    public TrendsImpl(StatisticsService statService) {
        this.statService = statService;
    }

    @Override
    public List<Trends.Query> getQueries() throws RepositoryException {
        MostPopularQueriesReport report = new MostPopularQueriesReport(this.statService.getPath() + "/queries");
        report.setSize(this.getMaxQueries());
        TreeMap<String, Long> queries = new TreeMap<String, Long>();
        Iterator it = this.statService.runReport((Report)report);
        while (it.hasNext()) {
            Long num;
            Object[] data = (Object[])it.next();
            String query = (String)data[0];
            Long previous = queries.put(query, num = (Long)data[1]);
            if (previous == null) continue;
            queries.put(query, previous + num);
        }
        if (queries.size() == 0) {
            return Collections.emptyList();
        }
        long min = Long.MAX_VALUE;
        long max = 0L;
        for (Long i : queries.values()) {
            min = Math.min(i, min);
            max = Math.max(i, max);
        }
        ArrayList<Trends.Query> result = new ArrayList<Trends.Query>();
        for (Map.Entry e : queries.entrySet()) {
            long size = max != min ? ((Long)e.getValue() - min) * (long)(this.maxSize - this.minSize) / (max - min) + (long)this.minSize : (long)((this.maxSize + this.minSize) / 2);
            result.add(new QueryImpl((String)e.getKey(), (int)size));
        }
        return result;
    }

    @Override
    public int getMinSize() {
        return this.minSize;
    }

    @Override
    public void setMinSize(int minSize) {
        this.minSize = minSize;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public int getMaxQueries() {
        return this.maxQueries;
    }

    @Override
    public void setMaxQueries(int maxQueries) {
        this.maxQueries = maxQueries;
    }

    public static class QueryImpl
    implements Trends.Query {
        private final String query;
        private final int size;

        QueryImpl(String query, int size) {
            this.query = query;
            this.size = size;
        }

        public String getQuery() {
            return this.query;
        }

        public int getSize() {
            return this.size;
        }
    }
}

