/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.impl.result;

import com.day.cq.search.facets.Facet;
import com.day.cq.search.impl.builder.QueryImpl;
import com.day.cq.search.impl.result.HitImpl;
import com.day.cq.search.impl.result.ResultPageImpl;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.ResultPage;
import com.day.cq.search.result.SearchResult;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.jcr.RepositoryException;
import javax.jcr.query.RowIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResultImpl
implements SearchResult {
    private final QueryImpl query;
    private final long executionTime;
    private final long totalMatches;
    private final long startIndex;
    private final long hitsPerPage;
    private final List<Hit> hits;
    private final List<ResultPage> resultPages;
    private Map<String, Facet> facets;

    public SearchResultImpl(QueryImpl query, RowIterator rows, long executionTime, long startIndex, long hitsPerPage) {
        long minPage;
        long currentPageIndex;
        long maxPage;
        this.query = query;
        this.executionTime = executionTime;
        this.totalMatches = rows.getSize();
        this.hitsPerPage = hitsPerPage;
        try {
            rows.skip(startIndex);
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.startIndex = rows.getPosition();
        ArrayList<HitImpl> hits = new ArrayList<HitImpl>();
        for (long i = 0L; (hitsPerPage <= 0L || i < hitsPerPage) && rows.hasNext(); ++i) {
            hits.add(new HitImpl(query, rows.nextRow(), this.startIndex + i));
        }
        this.hits = Collections.unmodifiableList(hits);
        ArrayList<ResultPageImpl> resultPages = new ArrayList<ResultPageImpl>();
        if (hitsPerPage <= 0L) {
            maxPage = 1L;
            currentPageIndex = 1L;
        } else {
            maxPage = rows.getSize() / hitsPerPage;
            if (rows.getSize() % hitsPerPage > 0L) {
                ++maxPage;
            }
            currentPageIndex = this.startIndex / hitsPerPage;
        }
        maxPage = Math.min(maxPage, currentPageIndex + 10L);
        for (long i = minPage = Math.max(0L, currentPageIndex - 10L); i < maxPage; ++i) {
            resultPages.add(new ResultPageImpl(i, i * hitsPerPage, i == currentPageIndex));
        }
        this.resultPages = Collections.unmodifiableList(resultPages);
    }

    @Override
    public long getTotalMatches() {
        return this.totalMatches;
    }

    @Override
    public long getStartIndex() {
        return this.startIndex;
    }

    @Override
    public long getHitsPerPage() {
        return this.hitsPerPage;
    }

    @Override
    public List<Hit> getHits() {
        return this.hits;
    }

    @Override
    public List<ResultPage> getResultPages() {
        return this.resultPages;
    }

    @Override
    public ResultPage getPreviousPage() {
        ResultPage previous = null;
        for (ResultPage p : this.resultPages) {
            if (p.isCurrentPage()) break;
            previous = p;
        }
        return previous;
    }

    @Override
    public ResultPage getNextPage() {
        Iterator<ResultPage> it = this.resultPages.iterator();
        while (it.hasNext()) {
            ResultPage p = it.next();
            if (!p.isCurrentPage() || !it.hasNext()) continue;
            return it.next();
        }
        return null;
    }

    @Override
    public String getExecutionTime() {
        double seconds = (double)this.executionTime / 1000.0;
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMinimumFractionDigits(2);
        format.setMaximumFractionDigits(2);
        return format.format(seconds);
    }

    @Override
    public long getExecutionTimeMillis() {
        return this.executionTime;
    }

    static String encodeURL(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    @Override
    public Map<String, Facet> getFacets() throws RepositoryException {
        if (this.facets == null) {
            this.facets = this.query.extractFacets();
        }
        return this.facets;
    }

    @Override
    public String getQueryStatement() {
        return this.query.getStatement();
    }

    @Override
    public String getFilteringPredicates() {
        return this.query.getFilteringPredicates();
    }
}

