/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.writer;

import com.day.cq.search.Query;
import com.day.cq.search.result.Hit;
import com.day.cq.search.writer.ResultHitWriter;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.apache.sling.commons.json.jcr.JsonItemWriter;

public class FullNodeHitWriter
implements ResultHitWriter {
    public void write(Hit hit, JSONWriter writer, Query query) throws RepositoryException, JSONException {
        int maxRecursionLevels = Integer.parseInt(query.getPredicates().get("nodedepth", "0"));
        writer.key("jcr:path").value((Object)hit.getPath());
        new JsonNodeDumper().dump(hit.getNode(), writer, maxRecursionLevels);
    }

    private static class JsonNodeDumper
    extends JsonItemWriter {
        public JsonNodeDumper() {
            super(null);
        }

        public void dump(Node node, JSONWriter w, int maxRecursionLevels) throws RepositoryException, JSONException {
            PropertyIterator props = node.getProperties();
            while (props.hasNext()) {
                this.writeProperty(w, props.nextProperty());
            }
            int currentRecursionLevel = 0;
            if (this.recursionLevelActive(currentRecursionLevel, maxRecursionLevels)) {
                NodeIterator children = node.getNodes();
                while (children.hasNext()) {
                    Node n = children.nextNode();
                    this.dumpSingleNode(n, w, currentRecursionLevel, maxRecursionLevels);
                }
            }
        }
    }
}

