/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search;

import com.day.cq.search.Predicate;
import com.day.cq.search.PredicateConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicateGroup
extends Predicate
implements List<Predicate> {
    public static final String TYPE = "group";
    private List<Predicate> predicates = new ArrayList<Predicate>();
    private static int indent = 0;

    public PredicateGroup() {
        super(null, TYPE);
    }

    public PredicateGroup(String name) {
        super(name, TYPE);
    }

    public static PredicateGroup create(Map predicateParameterMap) {
        return PredicateConverter.createPredicates(predicateParameterMap);
    }

    public String toURL() {
        return PredicateConverter.toURL(this);
    }

    public boolean allRequired() {
        return !this.getBool("or");
    }

    public void setAllRequired(boolean all) {
        this.set("or", all ? "false" : "true");
    }

    public boolean isNegated() {
        return this.getBool("not");
    }

    public void setNegated(boolean not) {
        this.set("not", not ? "true" : "false");
    }

    public Predicate getByName(String name) {
        for (Predicate p : this.predicates) {
            if (!ObjectUtils.equals((Object)p.getName(), (Object)name)) continue;
            return p;
        }
        return null;
    }

    public Predicate getByPath(String path) {
        String[] splits = path.split("\\.", 2);
        Predicate predicate = this.getByName(splits[0]);
        if (predicate != null) {
            if (predicate instanceof PredicateGroup) {
                if (splits.length > 1) {
                    return ((PredicateGroup)predicate).getByPath(splits[1]);
                }
            } else {
                return predicate;
            }
        }
        return null;
    }

    @Override
    public PredicateGroup clone() {
        return this.clone(false);
    }

    @Override
    public PredicateGroup clone(boolean resetName) {
        PredicateGroup clone = (PredicateGroup)super.clone(resetName);
        clone.predicates = new ArrayList<Predicate>();
        for (Predicate p : this.predicates) {
            Predicate pc = p.clone(resetName);
            pc.setParent(clone);
            clone.predicates.add(pc);
        }
        return clone;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append("[\n");
        indent += 4;
        for (Predicate p : this) {
            this.appendIndent(buffer);
            buffer.append("{").append(p.toString()).append("}\n");
        }
        indent = indent <= 4 ? 0 : indent - 4;
        this.appendIndent(buffer);
        buffer.append("]");
        return buffer.toString();
    }

    private void appendIndent(StringBuffer buffer) {
        for (int i = 0; i < indent; ++i) {
            buffer.append(" ");
        }
    }

    protected void setMeAsParent(Predicate element) {
        element.setParent(this);
    }

    protected void unsetParent(Predicate element) {
        element.setParent(null);
    }

    @Override
    public boolean add(Predicate o) {
        this.setMeAsParent(o);
        return this.predicates.add(o);
    }

    @Override
    public void add(int index, Predicate element) {
        this.setMeAsParent(element);
        this.predicates.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends Predicate> c) {
        for (Predicate predicate : c) {
            this.setMeAsParent(predicate);
        }
        return this.predicates.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Predicate> c) {
        for (Predicate predicate : c) {
            this.setMeAsParent(predicate);
        }
        return this.predicates.addAll(index, c);
    }

    @Override
    public void clear() {
        for (Predicate p : this.predicates) {
            this.unsetParent(p);
        }
        this.predicates.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.predicates.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.predicates.containsAll(c);
    }

    @Override
    public Predicate get(int index) {
        return this.predicates.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.predicates.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.predicates.isEmpty();
    }

    @Override
    public Iterator<Predicate> iterator() {
        return this.predicates.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.predicates.lastIndexOf(o);
    }

    @Override
    public ListIterator<Predicate> listIterator() {
        return this.predicates.listIterator();
    }

    @Override
    public ListIterator<Predicate> listIterator(int index) {
        return this.predicates.listIterator(index);
    }

    @Override
    public boolean remove(Object o) {
        this.unsetParent((Predicate)o);
        return this.predicates.remove(o);
    }

    @Override
    public Predicate remove(int index) {
        Predicate p = this.predicates.remove(index);
        this.unsetParent(p);
        return p;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object o : c) {
            this.unsetParent((Predicate)o);
        }
        return this.predicates.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        for (Predicate p : this) {
            if (c.contains(p)) continue;
            this.unsetParent(p);
        }
        return this.predicates.retainAll(c);
    }

    @Override
    public Predicate set(int index, Predicate element) {
        this.setMeAsParent(element);
        return this.predicates.set(index, element);
    }

    @Override
    public int size() {
        return this.predicates.size();
    }

    @Override
    public List<Predicate> subList(int fromIndex, int toIndex) {
        return this.predicates.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.predicates.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.predicates.toArray(a);
    }
}

