/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.eval;

import com.day.cq.search.Predicate;
import com.day.cq.search.eval.AbstractPredicateEvaluator;
import com.day.cq.search.eval.EvaluationContext;
import com.day.cq.search.eval.XPath;
import com.day.cq.search.facets.FacetExtractor;
import com.day.cq.search.facets.extractors.DistinctValuesFacetExtractor;
import com.day.text.GlobPattern;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.query.Row;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrPropertyPredicateEvaluator
extends AbstractPredicateEvaluator {
    private static final Logger log = LoggerFactory.getLogger(JcrPropertyPredicateEvaluator.class);
    public static final String PROPERTY = "property";
    public static final String VALUE = "value";
    public static final String OPERATION = "operation";
    public static final String OP_EQUALS = "equals";
    public static final String OP_UNEQUALS = "unequals";
    public static final String OP_LIKE = "like";
    public static final String OP_NOT = "not";
    public static final String OP_EXISTS = "exists";
    public static final String AND = "and";
    public static final int MAX_NUMBER_OF_VALUES = Integer.MAX_VALUE;

    public String getXPathExpression(Predicate p, EvaluationContext context) {
        String property = p.get(PROPERTY);
        String operation = p.get(OPERATION);
        if (OP_NOT.equals(operation) || OP_EXISTS.equals(operation) || p.hasNonEmptyValue(VALUE)) {
            return this.getXPathExpression(property, p.get(VALUE), this.getOperation(p, operation));
        }
        boolean and = p.getBool(AND);
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (Map.Entry<String, String> entry : p.getParameters().entrySet()) {
            String key = entry.getKey();
            if (key == null || !key.endsWith("_value")) continue;
            if (builder.length() > 1) {
                builder.append(and ? " and " : " or ");
            }
            builder.append(this.getXPathExpression(property, entry.getValue(), operation));
        }
        if (builder.length() == 1) {
            return null;
        }
        builder.append(")");
        return builder.toString();
    }

    protected String getXPathExpression(String property, String value, String operation) {
        if (property == null || property.length() == 0 || !OP_NOT.equals(operation) && !OP_EXISTS.equals(operation) && (value == null || value.length() == 0)) {
            return null;
        }
        if (OP_EQUALS.equals(operation)) {
            return XPath.getEqualsExpression(property, value);
        }
        if (OP_UNEQUALS.equals(operation)) {
            return XPath.getUnequalsExpression(property, value);
        }
        if (OP_LIKE.equals(operation)) {
            return XPath.getJcrLikeExpression(property, value);
        }
        if (OP_EXISTS.equals(operation)) {
            return XPath.getPropertyPath(property);
        }
        if (OP_NOT.equals(operation)) {
            return XPath.getNotExpression(property);
        }
        return XPath.getEqualsExpression(property, value);
    }

    protected String getEqualsExpression(String property, String value) {
        return XPath.getEqualsExpression(property, value);
    }

    private String getOperation(Predicate p, String operation) {
        if (OP_EXISTS.equals(operation) && "false".equals(p.get(VALUE, "true"))) {
            operation = OP_NOT;
        }
        return operation;
    }

    public String[] getOrderByProperties(Predicate p, EvaluationContext context) {
        return new String[]{p.get(PROPERTY)};
    }

    public FacetExtractor getFacetExtractor(Predicate p, EvaluationContext context) {
        if (p.hasNonEmptyValue(PROPERTY)) {
            Predicate template = p.clone();
            template.set(OPERATION, OP_EQUALS);
            return new DistinctValuesFacetExtractor(p.get(PROPERTY), null, template, VALUE);
        }
        return null;
    }

    public boolean includes(Predicate p, Row row, EvaluationContext context) {
        String operation = p.get(OPERATION, OP_EQUALS);
        if (OP_NOT.equals(operation) || OP_EXISTS.equals(operation) || p.hasNonEmptyValue(VALUE)) {
            return this.includes(context.getNode(row), context.getPath(row), p.get(PROPERTY), p.get(VALUE), this.getOperation(p, operation));
        }
        boolean and = p.getBool(AND);
        operation = this.getOperation(p, operation);
        for (Map.Entry<String, String> entry : p.getParameters().entrySet()) {
            String key = entry.getKey();
            if (key == null || !key.endsWith("_value")) continue;
            boolean match = this.includes(context.getNode(row), context.getPath(row), p.get(PROPERTY), entry.getValue(), operation);
            if (and) {
                if (match) continue;
                return false;
            }
            if (!match) continue;
            return true;
        }
        return and;
    }

    protected boolean includes(Node node, String path, String property, String value, String operation) {
        if (property == null || property.length() == 0 || !OP_NOT.equals(operation) && !OP_EXISTS.equals(operation) && (value == null || value.length() == 0)) {
            return true;
        }
        try {
            String childNode = Text.getRelativeParent((String)property, (int)1);
            String propName = Text.getName((String)property);
            if (childNode.length() > 0) {
                if (node.hasNode(childNode)) {
                    node = node.getNode(childNode);
                } else {
                    return false;
                }
            }
            if (node.hasProperty(propName)) {
                Property prop = node.getProperty(propName);
                if (prop.isMultiple()) {
                    if (OP_NOT.equals(operation)) {
                        return prop.getValues() == null || prop.getValues().length == 0;
                    }
                    if (OP_EXISTS.equals(operation)) {
                        return prop.getValues() != null && prop.getValues().length > 0;
                    }
                    for (Value v : prop.getValues()) {
                        if (!this.matches(value, operation, v.getString())) continue;
                        return true;
                    }
                    return false;
                }
                return this.matches(value, operation, prop.getString());
            }
            if (OP_NOT.equals(operation)) {
                return true;
            }
            if (OP_EXISTS.equals(operation)) {
                return false;
            }
            return false;
        }
        catch (ValueFormatException e) {
            log.warn("Could not evaluate property = '" + property + "', value = '" + value + "', node = '" + path + "'", (Throwable)e);
        }
        catch (RepositoryException e) {
            log.error("Could not evaluate property = '" + property + "', value = '" + value + "', node = '" + path + "'", (Throwable)e);
            throw new RuntimeException("", e);
        }
        return true;
    }

    private boolean matches(String value, String operation, String propValue) {
        if (OP_NOT.equals(operation)) {
            return propValue == null;
        }
        if (OP_EXISTS.equals(operation)) {
            return propValue != null;
        }
        if (OP_EQUALS.equals(operation)) {
            return propValue.equals(value);
        }
        if (OP_UNEQUALS.equals(operation)) {
            return !propValue.equals(value);
        }
        if (OP_LIKE.equals(operation)) {
            return GlobPattern.matches((String)this.convertWildcardsForGlobPattern(value), (String)propValue);
        }
        return false;
    }

    private String convertWildcardsForGlobPattern(String term) {
        return term.replace('%', '*').replace('_', '?');
    }

    public boolean canXpath(Predicate predicate, EvaluationContext context) {
        return true;
    }

    public boolean canFilter(Predicate predicate, EvaluationContext context) {
        return true;
    }
}

