/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.eval;

import com.day.cq.search.Predicate;
import com.day.cq.search.eval.AbstractPredicateEvaluator;
import com.day.cq.search.eval.EvaluationContext;
import com.day.cq.search.facets.FacetExtractor;
import com.day.cq.search.facets.extractors.DistinctValuesFacetExtractor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.query.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypePredicateEvaluator
extends AbstractPredicateEvaluator {
    private static final Logger log = LoggerFactory.getLogger(TypePredicateEvaluator.class);
    public static final String TYPE = "type";
    protected static final String NO_SUCH_NODETYPE = TypePredicateEvaluator.class.getName() + ".no-such-nodetype.";
    protected static final String NODETYPE_FOUND = TypePredicateEvaluator.class.getName() + ".nodetype-found.";

    @Override
    public String getXPathExpression(Predicate p, EvaluationContext context) {
        if (!p.hasNonEmptyValue(TYPE)) {
            return null;
        }
        String typeName = p.get(TYPE);
        ArrayList<NodeType> searchNodeTypes = new ArrayList<NodeType>();
        try {
            NodeType nodeType;
            NodeTypeManager nodeTypeManager = context.getSession().getWorkspace().getNodeTypeManager();
            try {
                nodeType = nodeTypeManager.getNodeType(typeName);
            }
            catch (NoSuchNodeTypeException ne) {
                log.warn("Node type '" + typeName + "' not found");
                return null;
            }
            searchNodeTypes.add(nodeType);
            searchNodeTypes.addAll(this.getDescendentNodeTypes(nodeType, nodeTypeManager));
        }
        catch (RepositoryException e) {
            log.debug("could not find child node types for '" + typeName + "'", (Throwable)e);
        }
        StringBuffer xpath = new StringBuffer();
        xpath.append("(");
        for (NodeType nt : searchNodeTypes) {
            if (xpath.length() > 1) {
                xpath.append(" or ");
            }
            if (nt.isMixin()) {
                xpath.append("@").append("jcr:mixinTypes");
            } else {
                xpath.append("@").append("jcr:primaryType");
            }
            xpath.append(" = '").append(nt.getName()).append("'");
        }
        xpath.append(")");
        return xpath.toString();
    }

    @Override
    public boolean includes(Predicate p, Row row, EvaluationContext context) {
        if (!p.hasNonEmptyValue(TYPE)) {
            return true;
        }
        String type = TypePredicateEvaluator.getType(p, context);
        if (type == null) {
            return false;
        }
        Node node = context.getNode(row);
        try {
            return node.isNodeType(type);
        }
        catch (RepositoryException e) {
            log.error("Problem while checking node for node type '" + p.get(TYPE) + "'", (Throwable)e);
            return false;
        }
    }

    public static String getType(Predicate p, EvaluationContext context) {
        String type = p.get(TYPE);
        if (context.get(NO_SUCH_NODETYPE + type) != null) {
            return null;
        }
        if (context.get(NODETYPE_FOUND + type) == null) {
            try {
                NodeTypeManager nodeTypeManager = context.getSession().getWorkspace().getNodeTypeManager();
                try {
                    nodeTypeManager.getNodeType(type);
                }
                catch (NoSuchNodeTypeException ne) {
                    log.warn("Node type '" + type + "' not found");
                    context.put(NO_SUCH_NODETYPE + type, true);
                    return null;
                }
                context.put(NODETYPE_FOUND + type, true);
            }
            catch (RepositoryException e) {
                log.error("Problem while checking node for node type '" + p.get(TYPE) + "'", (Throwable)e);
                return null;
            }
        }
        return type;
    }

    @Override
    public boolean canXpath(Predicate p, EvaluationContext context) {
        return true;
    }

    @Override
    public boolean canFilter(Predicate p, EvaluationContext context) {
        return true;
    }

    @Override
    public String[] getOrderByProperties(Predicate p, EvaluationContext context) {
        return new String[]{"jcr:primaryType", "jcr:mixinTypes"};
    }

    @Override
    public FacetExtractor getFacetExtractor(Predicate predicate, EvaluationContext context) {
        return new DistinctValuesFacetExtractor("jcr:primaryType", null, predicate.clone(), TYPE);
    }

    protected List<NodeType> getDescendentNodeTypes(NodeType nodeType, NodeTypeManager nodeTypeManager) throws RepositoryException {
        ArrayList<NodeType> childNodeTypes = new ArrayList<NodeType>();
        NodeTypeIterator allTypes = nodeTypeManager.getAllNodeTypes();
        while (allTypes.hasNext()) {
            NodeType nt = allTypes.nextNodeType();
            if (!Arrays.asList(nt.getSupertypes()).contains(nodeType)) continue;
            childNodeTypes.add(nt);
        }
        return childNodeTypes;
    }
}

