/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.facets.buckets;

import com.day.cq.search.Predicate;
import com.day.cq.search.facets.buckets.PredefinedBucket;
import javax.jcr.RepositoryException;
import javax.jcr.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueRangeBucket
extends PredefinedBucket {
    private final Comparable from;
    private final Comparable to;
    private boolean fromIncluded;
    private boolean toIncluded;

    public ValueRangeBucket(String name, Comparable from, boolean fromIncluded, Comparable to, boolean toIncluded, Predicate predicate) {
        super(predicate, name);
        this.from = from;
        this.to = to;
        this.fromIncluded = fromIncluded;
        this.toIncluded = toIncluded;
    }

    public Comparable getFrom() {
        return this.from;
    }

    public Comparable getTo() {
        return this.to;
    }

    @Override
    public void acceptValue(Value value) throws RepositoryException {
        if (this.matches(this.valueToComparable(value))) {
            this.increment();
        }
    }

    protected Comparable valueToComparable(Value value) throws RepositoryException {
        switch (value.getType()) {
            case 5: {
                return Long.valueOf(value.getLong());
            }
            case 4: {
                return Double.valueOf(value.getDouble());
            }
            case 3: {
                return Long.valueOf(value.getLong());
            }
        }
        return value.getString();
    }

    protected boolean matches(Comparable c) {
        try {
            Comparable value = this.coerce(c);
            if (value == null) {
                return false;
            }
            if (this.from == null && this.to == null) {
                return true;
            }
            if (this.from != null && (this.fromIncluded ? this.from.compareTo(value) > 0 : this.from.compareTo(value) >= 0)) {
                return false;
            }
            return this.to == null || !(this.toIncluded ? this.to.compareTo(value) < 0 : this.to.compareTo(value) <= 0);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private Comparable coerce(Comparable value) {
        return this.coerceValue(this.from != null ? this.from.getClass() : this.to.getClass(), value);
    }

    protected Comparable coerceValue(Class<? extends Comparable> type, Comparable value) {
        if (value.getClass() == type) {
            return value;
        }
        if (type == Long.class) {
            try {
                return Long.valueOf(Long.parseLong(value.toString()));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (type == Integer.class) {
            try {
                return Integer.valueOf(Integer.parseInt(value.toString()));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (type == Double.class) {
            try {
                return Double.valueOf(Double.parseDouble(value.toString()));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (type == String.class) {
            return value.toString();
        }
        return null;
    }
}

