/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.impl;

import com.day.cq.search.QueryBuilder;
import com.day.cq.search.SimpleSearch;
import com.day.cq.search.impl.SimpleSearchImpl;
import com.day.cq.statistics.StatisticsService;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchAdapterFactory
implements AdapterFactory {
    private static final Logger log = LoggerFactory.getLogger(SearchAdapterFactory.class);
    private static final Class<Resource> RESOURCE_CLASS = Resource.class;
    private static final Class<SimpleSearch> SEARCH_CLASS = SimpleSearch.class;
    private static final Class<ResourceResolver> RESOURCE_RESOLVER_CLASS = ResourceResolver.class;
    private static final Class<QueryBuilder> QUERYBUILDER_CLASS = QueryBuilder.class;
    protected static final String[] ADAPTABLE_CLASSES = new String[]{RESOURCE_CLASS.getName(), RESOURCE_RESOLVER_CLASS.getName()};
    protected static final String[] ADAPTER_CLASSES = new String[]{SEARCH_CLASS.getName(), QUERYBUILDER_CLASS.getName()};
    private StatisticsService statsService;
    protected QueryBuilder builder;

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        if (adaptable instanceof Resource) {
            return this.getAdapter((Resource)adaptable, type);
        }
        if (adaptable instanceof ResourceResolver) {
            return this.getAdapter((ResourceResolver)adaptable, type);
        }
        log.warn("Unable to handle adaptable {}", (Object)adaptable.getClass().getName());
        return null;
    }

    private <AdapterType> AdapterType getAdapter(Resource resource, Class<AdapterType> type) {
        if (type == SEARCH_CLASS) {
            return (AdapterType)new SimpleSearchImpl(resource, this.builder, this.statsService);
        }
        log.debug("Unable to adapt resource to type {}", (Object)type.getName());
        return null;
    }

    private <AdapterType> AdapterType getAdapter(ResourceResolver resource, Class<AdapterType> type) {
        if (type == QUERYBUILDER_CLASS) {
            return (AdapterType)this.builder;
        }
        log.debug("Unable to adapt resource to type {}", (Object)type.getName());
        return null;
    }

    protected void bindStatsService(StatisticsService statisticsService) {
        this.statsService = statisticsService;
    }

    protected void unbindStatsService(StatisticsService statisticsService) {
        if (this.statsService == statisticsService) {
            this.statsService = null;
        }
    }

    protected void bindBuilder(QueryBuilder queryBuilder) {
        this.builder = queryBuilder;
    }

    protected void unbindBuilder(QueryBuilder queryBuilder) {
        if (this.builder == queryBuilder) {
            this.builder = null;
        }
    }
}

