/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.impl;

import com.day.cq.search.Predicate;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.SimpleSearch;
import com.day.cq.search.Trends;
import com.day.cq.search.impl.misc.TrendsImpl;
import com.day.cq.search.result.SearchResult;
import com.day.cq.statistics.StatisticsService;
import com.day.crx.statistics.Report;
import com.day.crx.statistics.result.RelatedQueriesReport;
import com.day.text.Text;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSearchImpl
implements SimpleSearch {
    private String query;
    private long start;
    private List<String> searchProperties = new ArrayList<String>(Arrays.asList(".", "jcr:title", "jcr:description"));
    private String searchIn;
    private long hitsPerPage = 10L;
    private final StatisticsService statsService;
    private final Resource resource;
    private Session session;
    private SearchResult result;
    private Trends trends;
    private QueryBuilder builder;
    private List<Predicate> customPredicates = new ArrayList<Predicate>();

    public SimpleSearchImpl(Resource resource, QueryBuilder builder, StatisticsService statsService) {
        this.resource = resource;
        this.builder = builder;
        this.statsService = statsService;
        this.searchIn = Text.getAbsoluteParent((String)resource.getPath(), (int)0);
    }

    @Override
    public SearchResult getResult() throws RepositoryException {
        if (this.result == null) {
            String queryString = this.getQuery();
            if (queryString.length() == 0 && this.customPredicates.size() == 0) {
                return null;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("path", this.getSearchIn());
            boolean typeOverwrite = false;
            for (Predicate p : this.customPredicates) {
                if (!"type".equals(p.getName())) continue;
                typeOverwrite = true;
                break;
            }
            if (!typeOverwrite) {
                map.put("type", "nt:hierarchyNode");
            }
            if (queryString.startsWith("related:")) {
                String path = queryString.substring("related:".length());
                map.put("similar", path + "/" + "jcr:content");
                map.put("similar.local", "jcr:content");
            } else {
                int counter = 0;
                map.put("group.p.or", "true");
                for (String prop : this.searchProperties) {
                    map.put("group." + counter + "_fulltext", queryString);
                    StringBuffer path = new StringBuffer();
                    path.append("jcr:content");
                    if (!prop.equals(".")) {
                        String[] segments = Text.explode((String)prop, (int)47);
                        for (int i = 0; i < segments.length; ++i) {
                            path.append("/");
                            if (i == segments.length - 1) {
                                path.append("@");
                            }
                            path.append(segments[i]);
                        }
                    }
                    map.put("group." + counter + "_fulltext.relPath", path.toString());
                    ++counter;
                }
            }
            Query query = this.builder.createQuery(PredicateGroup.create(map), this.getSession());
            for (Predicate p : this.customPredicates) {
                query.getPredicates().add(p);
            }
            query.setExcerpt(true);
            query.setStart(this.start);
            query.setHitsPerPage(this.hitsPerPage);
            this.result = query.getResult();
        }
        return this.result;
    }

    @Override
    public Trends getTrends() {
        if (this.trends == null) {
            this.trends = new TrendsImpl(this.getSession(), this.statsService);
        }
        return this.trends;
    }

    @Override
    public List<String> getRelatedQueries() throws RepositoryException {
        ArrayList<String> related = new ArrayList<String>();
        RelatedQueriesReport report = new RelatedQueriesReport(this.statsService.getPath() + "/results", this.getQuery());
        Iterator it = this.statsService.runReport(this.getSession(), (Report)report);
        while (it.hasNext()) {
            Object[] data = (Object[])it.next();
            related.add((String)data[0]);
        }
        return related;
    }

    @Override
    public String getQuery() {
        return this.query != null ? this.query : "";
    }

    @Override
    public void setQuery(String query) {
        this.query = query;
        this.resetResult();
    }

    @Override
    public long getHitsPerPage() {
        return this.hitsPerPage;
    }

    @Override
    public void setHitsPerPage(long num) {
        this.hitsPerPage = num;
        this.resetResult();
    }

    @Override
    public String getSearchIn() {
        return this.searchIn;
    }

    @Override
    public void setSearchIn(String searchIn) {
        if (searchIn == null) {
            searchIn = "";
        }
        if (searchIn.endsWith("/")) {
            searchIn = searchIn.substring(0, searchIn.length() - 1);
        }
        this.searchIn = searchIn;
        this.resetResult();
    }

    @Override
    public String getSearchProperties() {
        return Text.implode((String[])this.searchProperties.toArray(new String[this.searchProperties.size()]), (String)", ");
    }

    @Override
    public void setSearchProperties(String properties) {
        String[] props;
        this.searchProperties.clear();
        for (String p : props = Text.explode((String)properties, (int)44)) {
            this.searchProperties.add(p.trim());
        }
        this.resetResult();
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public void setStart(long start) {
        this.start = start;
        this.resetResult();
    }

    @Override
    public void addPredicate(Predicate predicate) {
        this.customPredicates.add(predicate);
        this.resetResult();
    }

    Session getSession() {
        if (this.session == null) {
            this.session = (Session)this.resource.getResourceResolver().adaptTo(Session.class);
        }
        return this.session;
    }

    private void resetResult() {
        this.result = null;
    }
}

