/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.impl.builder;

import com.day.cq.search.PredicateGroup;
import com.day.cq.search.eval.EvaluationContext;
import com.day.cq.search.eval.PredicateEvaluator;
import com.day.cq.search.impl.builder.QueryImpl;
import com.day.cq.search.impl.builder.RootEvaluator;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Row;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluationContextImpl
implements EvaluationContext {
    private static final Logger log = LoggerFactory.getLogger(EvaluationContextImpl.class);
    private QueryImpl query;
    private Map<String, Object> map = new HashMap<String, Object>();
    private RootEvaluator rootEvaluator;

    public EvaluationContextImpl(QueryImpl query, RootEvaluator rootEvaluator) {
        this.query = query;
        this.rootEvaluator = rootEvaluator;
    }

    public PredicateEvaluator getPredicateEvaluator(String type) {
        return this.query.getPredicateEvaluator(type);
    }

    public Session getSession() {
        return this.query.getSession();
    }

    public Node getNode(Row row) {
        try {
            return row.getNode();
        }
        catch (RepositoryException e) {
            log.warn("Could not retrive jcr:path value from row", (Throwable)e);
            return null;
        }
    }

    public ResourceResolver getResourceResolver() {
        return this.query.getResourceResolver();
    }

    public String getPath(Row row) {
        try {
            return row.getPath();
        }
        catch (RepositoryException e) {
            log.warn("Could not retrive jcr:path value from row", (Throwable)e);
            return null;
        }
    }

    public Resource getResource(Row row) {
        return this.getResourceResolver().getResource(this.getPath(row));
    }

    public void put(String key, Object value) {
        if (value == null) {
            this.map.remove(key);
        } else {
            this.map.put(key, value);
        }
    }

    public Object get(String key) {
        return this.map.get(key);
    }

    public RootEvaluator getRootEvaluator() {
        return this.rootEvaluator;
    }

    public PredicateGroup getRootPredicate() {
        return this.query.getPredicates();
    }
}

