/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.impl.builder;

import com.day.cq.search.eval.EvaluationContext;
import java.util.Comparator;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.query.Row;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyComparator
implements Comparator<Row> {
    private String property;
    private EvaluationContext context;

    public PropertyComparator(String property, EvaluationContext context) {
        this.property = property;
        this.context = context;
    }

    @Override
    public int compare(Row r1, Row r2) {
        Node node1 = this.context.getNode(r1);
        if (node1 == null) {
            return 0;
        }
        Node node2 = this.context.getNode(r2);
        if (node2 == null) {
            return 0;
        }
        try {
            if (!node1.hasProperty(this.property)) {
                return -1;
            }
            if (!node2.hasProperty(this.property)) {
                return 1;
            }
            Property prop1 = node1.getProperty(this.property);
            boolean multiValued = prop1.getDefinition().isMultiple();
            Property prop2 = node2.getProperty(this.property);
            if (prop2.getDefinition().isMultiple() != multiValued) {
                return multiValued ? 1 : -1;
            }
            if (multiValued) {
                Value[] values2;
                Value[] values1 = prop1.getValues();
                if (values1.length < (values2 = prop2.getValues()).length) {
                    return -1;
                }
                if (values1.length > values2.length) {
                    return 1;
                }
                for (int i = 0; i < values1.length; ++i) {
                    int c = this.compareValues(values1[i], values2[i]);
                    if (c == 0) continue;
                    return c;
                }
                return 0;
            }
            return this.compareValues(prop1.getValue(), prop2.getValue());
        }
        catch (RepositoryException e) {
            return 0;
        }
    }

    public int compareValues(Value val1, Value val2) throws ValueFormatException, IllegalStateException, RepositoryException {
        if (val1.getType() != val2.getType()) {
            try {
                return val1.getString().compareTo(val2.getString());
            }
            catch (RepositoryException e) {
                return val2.getType() - val1.getType();
            }
        }
        switch (val1.getType()) {
            case 2: {
                return 0;
            }
            case 3: {
                return Long.valueOf(val1.getLong()).compareTo(val2.getLong());
            }
            case 4: {
                return Double.valueOf(val1.getDouble()).compareTo(val2.getDouble());
            }
            case 6: {
                return Boolean.valueOf(val1.getBoolean()).compareTo(val2.getBoolean());
            }
            case 5: {
                return val1.getDate().compareTo(val2.getDate());
            }
        }
        return val1.getString().compareTo(val2.getString());
    }
}

