/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.impl.builder;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.search.PredicateConverter;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.impl.builder.QueryImpl;
import com.day.cq.search.impl.builder.RootEvaluator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryBuilderImpl
implements QueryBuilder {
    private static final Logger log = LoggerFactory.getLogger(QueryBuilderImpl.class);
    private static final String PROPERTIES_ENCODING = "ISO-8859-1";
    private Map<Object, ServiceReference> refMap = new HashMap<Object, ServiceReference>();
    private Map<Object, ComponentInstance> instanceMap = new HashMap<Object, ComponentInstance>();
    private JcrResourceResolverFactory jcrResourceResolverFactory;
    private BundleContext bundleContext;
    private static final String EXCERPT_PROPERTIES = "excerpt.properties";
    private Set<String> excerptProperties;

    @Override
    public Query createQuery(Session session) {
        return this.createQuery(new PredicateGroup(), session);
    }

    @Override
    public Query createQuery(PredicateGroup predicates, Session session) {
        return new QueryImpl(predicates, session, this);
    }

    @Override
    public Query loadQuery(String path, Session session) throws RepositoryException, IOException {
        String dataPath = path.substring(1);
        if (!session.getRootNode().hasProperty(dataPath)) {
            dataPath = path.substring(1) + "/" + "jcr:content" + "/" + "jcr:data";
            if (!session.getRootNode().hasProperty(dataPath)) {
                return null;
            }
        }
        Property data = session.getRootNode().getProperty(dataPath);
        Properties props = new Properties();
        if (data.getType() == 1) {
            props.load(new ByteArrayInputStream(data.getString().getBytes(PROPERTIES_ENCODING)));
        } else {
            props.load(data.getBinary().getStream());
        }
        PredicateGroup root = PredicateConverter.createPredicates(props);
        return this.createQuery(root, session);
    }

    @Override
    public void storeQuery(Query query, String path, boolean createFile, Session session) throws RepositoryException, IOException {
        Properties props = new Properties();
        props.putAll(PredicateConverter.createMap(query.getPredicates()));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        props.store(out, null);
        if (createFile) {
            Node node = JcrUtil.createPath((String)path, (String)"nt:unstructured", (String)"nt:file", (Session)session, (boolean)false);
            if (!node.isNodeType("nt:file")) {
                throw new RepositoryException("The path for saving the query already exists and is not of type nt:file: '" + path + "'");
            }
            node = node.hasNode("jcr:content") ? node.getNode("jcr:content") : node.addNode("jcr:content", "nt:resource");
            node.setProperty("jcr:mimeType", "text/plain");
            node.setProperty("jcr:encoding", PROPERTIES_ENCODING);
            node.setProperty("jcr:data", session.getValueFactory().createBinary((InputStream)new ByteArrayInputStream(out.toByteArray())));
            node.setProperty("jcr:lastModified", Calendar.getInstance());
        } else {
            String nodePath = Text.getRelativeParent((String)path, (int)1);
            String property = Text.getName((String)path);
            Node node = JcrUtil.createPath((String)nodePath, (String)"nt:unstructured", (Session)session);
            node.setProperty(property, new String(out.toByteArray(), PROPERTIES_ENCODING));
        }
        session.save();
    }

    public ResourceResolver createResourceResolver(Session session) {
        return this.jcrResourceResolverFactory.getResourceResolver(session);
    }

    public Set<String> getExcerptPropertyNames() {
        return this.excerptProperties;
    }

    public RootEvaluator creatRootEvaluator() {
        return new RootEvaluator();
    }

    protected void activate(ComponentContext context) {
        String[] excerptProps;
        this.bundleContext = context.getBundleContext();
        this.excerptProperties = new HashSet<String>();
        for (String prop : excerptProps = (String[])context.getProperties().get(EXCERPT_PROPERTIES)) {
            if (prop == null || prop.trim().length() <= 0) continue;
            this.excerptProperties.add(prop);
        }
    }

    protected void deactivate(ComponentContext context) {
        this.bundleContext = null;
        this.excerptProperties = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ComponentT> ComponentT getComponent(Class<ComponentT> typeClass, String type, Dictionary properties) {
        ServiceReference[] refs = null;
        try {
            refs = this.bundleContext.getServiceReferences(ComponentFactory.class.getName(), "(component.factory=" + typeClass.getName() + '/' + type + ')');
        }
        catch (InvalidSyntaxException e) {
            log.error("Unable to get " + typeClass.getSimpleName() + " instance: " + type, (Throwable)e);
            return null;
        }
        if (refs == null || refs.length == 0) {
            return null;
        }
        ServiceReference ref = refs[0];
        ComponentFactory factory = (ComponentFactory)this.bundleContext.getService(ref);
        ComponentInstance instance = factory.newInstance(properties);
        Object component = instance.getInstance();
        if (component == null) {
            log.error("Unable to get " + typeClass.getSimpleName() + " instance: " + type);
            instance.dispose();
            this.bundleContext.ungetService(ref);
        } else {
            Map<Object, ServiceReference> map = this.refMap;
            synchronized (map) {
                this.refMap.put(component, ref);
                this.instanceMap.put(component, instance);
            }
        }
        return (ComponentT)component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseComponent(Object component) {
        Map<Object, ServiceReference> map = this.refMap;
        synchronized (map) {
            if (this.instanceMap.containsKey(component)) {
                this.instanceMap.get(component).dispose();
                this.instanceMap.remove(component);
            }
            if (this.refMap.containsKey(component)) {
                this.bundleContext.ungetService(this.refMap.get(component));
                this.refMap.remove(component);
            }
        }
    }

    protected void bindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.jcrResourceResolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.jcrResourceResolverFactory == jcrResourceResolverFactory) {
            this.jcrResourceResolverFactory = null;
        }
    }
}

