/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.impl.builder;

import com.day.cq.search.Predicate;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.eval.EvaluationContext;
import com.day.cq.search.eval.PredicateEvaluator;
import com.day.cq.search.facets.Bucket;
import com.day.cq.search.facets.Facet;
import com.day.cq.search.facets.FacetExtractor;
import com.day.cq.search.impl.builder.EmptyQueryResult;
import com.day.cq.search.impl.builder.EvaluationContextImpl;
import com.day.cq.search.impl.builder.PropertyComparator;
import com.day.cq.search.impl.builder.QueryBuilderImpl;
import com.day.cq.search.impl.builder.RootEvaluator;
import com.day.cq.search.impl.result.EmptySearchResult;
import com.day.cq.search.impl.result.SearchResultImpl;
import com.day.cq.search.result.SearchResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.collections.iterators.EmptyIterator;
import org.apache.jackrabbit.commons.iterator.RangeIteratorAdapter;
import org.apache.jackrabbit.commons.iterator.RowIteratorAdapter;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryImpl
implements Query {
    private static final Logger log = LoggerFactory.getLogger(QueryImpl.class);
    private final Session session;
    private final QueryBuilderImpl queryBuilder;
    private final PredicateGroup rootPredicate;
    private SearchResult result;
    private QueryResult rawQueryResult;
    private ResourceResolver resourceResolver;
    private Iterable<Row> realResultRows;
    private Map<String, PredicateEvaluator> evaluators = new HashMap<String, PredicateEvaluator>();
    private String xpath;
    private String filteringPredicates;
    private Map<FacetExtractor, List<Predicate>> facetExtractors;

    public QueryImpl(PredicateGroup rootPredicate, Session session, QueryBuilderImpl queryBuilder) {
        this.rootPredicate = rootPredicate;
        this.session = session;
        this.queryBuilder = queryBuilder;
    }

    @Override
    public SearchResult getResult() {
        if (this.result == null) {
            this.result = this.execute();
        }
        return this.result;
    }

    @Override
    public PredicateGroup getPredicates() {
        return this.rootPredicate;
    }

    @Override
    public void registerPredicateEvaluator(String type, PredicateEvaluator evaluator) {
        if (type != null && type.length() > 0 && evaluator != null) {
            this.evaluators.put(type, evaluator);
        }
    }

    @Override
    public Query refine(Bucket bucket) {
        PredicateGroup targetRoot;
        Predicate p = bucket.getPredicate();
        if (this.rootPredicate.allRequired()) {
            int pos;
            targetRoot = this.rootPredicate.clone(true);
            Predicate origPredicate = this.rootPredicate.getByName(p.getPath());
            if (origPredicate != null && (pos = this.rootPredicate.indexOf(origPredicate)) >= 0) {
                targetRoot.remove(pos);
            }
            targetRoot.add(p.clone(true));
        } else {
            targetRoot = new PredicateGroup();
            targetRoot.setAllRequired(true);
            targetRoot.add(p.clone(true));
            targetRoot.add(this.rootPredicate.clone(true));
        }
        return new QueryImpl(targetRoot, this.session, this.queryBuilder);
    }

    @Override
    public void setExcerpt(boolean excerpt) {
        RootEvaluator.setExcerpt(this.rootPredicate, excerpt);
    }

    @Override
    public boolean getExcerpt() {
        return RootEvaluator.isExcerpt(this.rootPredicate);
    }

    @Override
    public long getStart() {
        try {
            return Long.parseLong(this.rootPredicate.get("offset", "0"));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Override
    public void setStart(long start) {
        if (start < 0L) {
            this.rootPredicate.set("offset", "0");
        } else {
            this.rootPredicate.set("offset", Long.toString(start));
        }
    }

    @Override
    public long getHitsPerPage() {
        try {
            return Long.parseLong(this.rootPredicate.get("limit", "10"));
        }
        catch (NumberFormatException e) {
            return 10L;
        }
    }

    @Override
    public void setHitsPerPage(long hitsPerPage) {
        if (hitsPerPage < 0L) {
            this.rootPredicate.set("limit", "10");
        } else {
            this.rootPredicate.set("limit", Long.toString(hitsPerPage));
        }
    }

    public boolean guessTotal() {
        return this.rootPredicate.getBool("guessTotal");
    }

    public Session getSession() {
        return this.session;
    }

    public ResourceResolver getResourceResolver() {
        if (this.resourceResolver == null) {
            this.resourceResolver = this.queryBuilder.createResourceResolver(this.session);
        }
        return this.resourceResolver;
    }

    public PredicateEvaluator getPredicateEvaluator(String type) {
        if ("orderby".equals(type)) {
            return null;
        }
        if (this.evaluators.containsKey(type)) {
            return this.evaluators.get(type);
        }
        PredicateEvaluator evaluator = this.queryBuilder.getComponent(PredicateEvaluator.class, type, null);
        if (evaluator == null) {
            log.warn("no PredicateEvaluator found for '{}'", (Object)type);
        }
        this.evaluators.put(type, evaluator);
        return evaluator;
    }

    private void releasePredicateEvaluators() {
        for (PredicateEvaluator pe : this.evaluators.values()) {
            this.queryBuilder.releaseComponent(pe);
        }
        this.evaluators.clear();
    }

    public Set<String> getExcerptPropertyNames() {
        return this.queryBuilder.getExcerptPropertyNames();
    }

    public QueryResult getRawQueryResult() {
        if (this.rawQueryResult == null) {
            this.getResult();
        }
        return this.rawQueryResult;
    }

    public Map<String, Facet> extractFacets() {
        List<Predicate> predicates;
        if (this.facetExtractors == null) {
            throw new IllegalStateException("Query.getFacets() can only be called after a successful call to getResult()");
        }
        long time = System.currentTimeMillis();
        HashMap<String, Facet> facets = new HashMap<String, Facet>();
        if (this.facetExtractors.size() == 0) {
            return facets;
        }
        if (log.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            for (FacetExtractor facetExtractor : this.facetExtractors.keySet()) {
                buffer.append(facetExtractor).append(" => {\n");
                predicates = this.facetExtractors.get(facetExtractor);
                for (Predicate p : predicates) {
                    buffer.append("    ").append(p.getPath()).append("\n");
                }
                buffer.append("}\n");
            }
            log.debug("facet extractors:\n {}", (Object)buffer.toString());
        }
        Iterator<Row> rowIter = this.realResultRows.iterator();
        try {
            while (rowIter.hasNext()) {
                String path = rowIter.next().getValue("jcr:path").getString();
                Node node = (Node)this.session.getItem(path);
                if (node == null) continue;
                for (FacetExtractor extractor : this.facetExtractors.keySet()) {
                    extractor.handleNode(node);
                }
            }
        }
        catch (RepositoryException e) {
            log.error("could not extract facets for search result", (Throwable)e);
        }
        for (FacetExtractor facetExtractor : this.facetExtractors.keySet()) {
            predicates = this.facetExtractors.get(facetExtractor);
            Facet facet = facetExtractor.getFacet();
            if (facet == null) continue;
            for (Predicate p : predicates) {
                facets.put(p.getPath(), facet);
            }
        }
        log.debug("facet extraction took {} ms", (Object)(System.currentTimeMillis() - time));
        return facets;
    }

    public String getStatement() {
        return this.xpath;
    }

    public String getFilteringPredicates() {
        return this.filteringPredicates;
    }

    private String getFilteringPredicates(EvaluationContextImpl context) {
        if (this.filteringPredicates == null) {
            this.filteringPredicates = context.getRootEvaluator().listFilteringPredicates(context.getRootPredicate(), context);
        }
        return this.filteringPredicates;
    }

    private boolean isFiltering(EvaluationContextImpl context) {
        return this.getFilteringPredicates(context).length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SearchResult execute() {
        RowIterator rowIter;
        long xpathTime;
        List<Comparator<Row>> comparators;
        EvaluationContextImpl context;
        RootEvaluator rootEvaluator;
        long time;
        block27: {
            if (this.rootPredicate.isEmpty()) {
                log.debug("empty query, returning empty result set");
                return new EmptySearchResult(0L);
            }
            if (log.isDebugEnabled()) {
                log.debug("executing query (URL):\n" + this.rootPredicate.toURL());
                log.debug("executing query (predicate tree):\n" + this.rootPredicate.toString());
            }
            time = System.currentTimeMillis();
            rootEvaluator = this.queryBuilder.creatRootEvaluator();
            context = new EvaluationContextImpl(this, rootEvaluator);
            comparators = this.extractOrderByPredicates(rootEvaluator, context);
            xpathTime = System.currentTimeMillis();
            this.xpath = rootEvaluator.getXPathExpression(this.rootPredicate, context);
            log.debug("xpath query: {}", (Object)this.xpath);
            if (!"//*".equals(this.xpath)) break block27;
            if (this.isFiltering(context) || comparators != null) {
                log.warn("full xpath repository query!");
                break block27;
            }
            log.debug("empty predicates, returning empty result set");
            EmptySearchResult emptySearchResult = new EmptySearchResult(System.currentTimeMillis() - time);
            rootEvaluator.cleanup();
            this.resetOrderByPredicates();
            this.releasePredicateEvaluators();
            return emptySearchResult;
        }
        try {
            String xpathSizeNote;
            boolean mustCount;
            try {
                QueryManager qm = this.session.getWorkspace().getQueryManager();
                this.rawQueryResult = qm.createQuery(this.xpath, "xpath").execute();
                log.debug("xpath query took {} ms", (Object)(System.currentTimeMillis() - xpathTime));
            }
            catch (RepositoryException e) {
                log.warn("Could not run xpath query", (Throwable)e);
                this.rawQueryResult = EmptyQueryResult.INSTANCE;
            }
            long filterTime = System.currentTimeMillis();
            RowIterator rawRowIter = this.rawQueryResult.getRows();
            long rawResults = rawRowIter.getSize();
            long finalResults = 0L;
            boolean unknownSize = rawResults < 0L;
            boolean bl = mustCount = unknownSize && !this.guessTotal();
            String string = mustCount ? " (counted)" : (xpathSizeNote = unknownSize ? " (guessed)" : "");
            if (unknownSize) {
                rawResults = 0L;
            } else {
                log.debug(">> xpath query returned {} results{}", (Object)rawResults, (Object)xpathSizeNote);
            }
            if (this.isFiltering(context)) {
                log.debug("filtering predicates: {}", (Object)this.getFilteringPredicates(context));
                ArrayList<Row> filteredRows = new ArrayList<Row>();
                while (rawRowIter.hasNext()) {
                    Row row = rawRowIter.nextRow();
                    if (rootEvaluator.includes(this.rootPredicate, row, context)) {
                        if (log.isTraceEnabled()) {
                            log.trace("adding row to result after filtering: {}", (Object)row.getValue("jcr:path").getString());
                        }
                        filteredRows.add(row);
                        ++finalResults;
                    }
                    ++rawResults;
                }
                this.realResultRows = filteredRows;
            } else if (mustCount) {
                ArrayList<Row> countedRows = new ArrayList<Row>();
                while (rawRowIter.hasNext()) {
                    countedRows.add(rawRowIter.nextRow());
                    ++rawResults;
                }
                finalResults = rawResults;
                this.realResultRows = countedRows;
            } else {
                finalResults = rawResults = rawRowIter.getSize();
                this.realResultRows = new Iterable<Row>(){

                    @Override
                    public Iterator<Row> iterator() {
                        try {
                            return QueryImpl.this.rawQueryResult.getRows();
                        }
                        catch (RepositoryException e) {
                            log.error("Could not get row iterator from result", (Throwable)e);
                            return EmptyIterator.INSTANCE;
                        }
                    }
                };
            }
            if (unknownSize) {
                if (rawResults < 0L) {
                    log.debug(">> xpath query returned unknown number of results ({})", (Object)rawResults);
                } else {
                    log.debug(">> xpath query returned {} results{}", (Object)rawResults, (Object)xpathSizeNote);
                }
            }
            if (this.isFiltering(context)) {
                log.debug("filtering took {} ms", (Object)(System.currentTimeMillis() - filterTime));
                log.debug(">> after filtering there are {} results", (Object)finalResults);
            }
            if (comparators != null) {
                log.debug("sorting result set...");
                long sortTime = System.currentTimeMillis();
                ArrayList<Row> rows = new ArrayList<Row>();
                for (Row r : this.realResultRows) {
                    rows.add(r);
                }
                Comparator chain = ComparatorUtils.chainedComparator(comparators);
                Collections.sort(rows, chain);
                this.realResultRows = rows;
                log.debug("sorting took {} ms", (Object)(System.currentTimeMillis() - sortTime));
            }
            rowIter = new RowIteratorAdapter((RangeIterator)new RangeIteratorAdapter(this.realResultRows.iterator(), finalResults));
            this.facetExtractors = new HashMap<FacetExtractor, List<Predicate>>();
            this.collectFacetExtractors(this.rootPredicate, this.facetExtractors, context);
        }
        catch (RepositoryException e) {
            log.warn("Could not execute query", (Throwable)e);
            rowIter = RowIteratorAdapter.EMPTY;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            rootEvaluator.cleanup();
            this.resetOrderByPredicates();
            this.releasePredicateEvaluators();
        }
        long executionTime = System.currentTimeMillis() - time;
        log.debug("entire query execution took {} ms", (Object)executionTime);
        return new SearchResultImpl(this, rowIter, executionTime, this.getStart(), this.getHitsPerPage());
    }

    private List<Comparator<Row>> extractOrderByPredicates(RootEvaluator rootEvaluator, EvaluationContext context) {
        ArrayList<Comparator<Row>> comparators = new ArrayList<Comparator<Row>>();
        boolean atLeastOneCustomComparator = false;
        for (Predicate p : this.rootPredicate) {
            Comparator<Row> customComparator;
            if (!"orderby".equals(p.getType()) || !p.hasNonEmptyValue("orderby")) continue;
            p.setIgnored(true);
            String orderBy = p.get("orderby");
            boolean ascending = p.get("sort", "asc").equals("asc");
            if (orderBy.startsWith("@")) {
                String prop = orderBy.substring(1);
                rootEvaluator.addOrderBySpec(prop, ascending);
                comparators.add(this.getComparator(new PropertyComparator(prop, context), ascending));
                continue;
            }
            Predicate predForOrder = this.rootPredicate.getByPath(orderBy);
            PredicateEvaluator pe = predForOrder != null ? context.getPredicateEvaluator(predForOrder.getType()) : context.getPredicateEvaluator(orderBy);
            if (pe == null) {
                log.warn("predicate referenced by orderby-predicate not found: {}", (Object)orderBy);
                continue;
            }
            if (pe == null) continue;
            String[] props = pe.getOrderByProperties(predForOrder, context);
            if (props != null) {
                for (String prop : props) {
                    rootEvaluator.addOrderBySpec(prop, ascending);
                    comparators.add(this.getComparator(new PropertyComparator(prop, context), ascending));
                }
            }
            if ((customComparator = pe.getOrderByComparator(predForOrder, context)) == null) continue;
            atLeastOneCustomComparator = true;
            log.debug("custom order by comparator: {}", (Object)orderBy);
            comparators.add(this.getComparator(customComparator, ascending));
        }
        if (atLeastOneCustomComparator) {
            return comparators;
        }
        return null;
    }

    private Comparator<Row> getComparator(Comparator<Row> c, boolean ascending) {
        if (ascending) {
            return c;
        }
        return Collections.reverseOrder(c);
    }

    private void resetOrderByPredicates() {
        for (Predicate p : this.rootPredicate) {
            if (!"orderby".equals(p.getType()) || !p.hasNonEmptyValue("orderby")) continue;
            p.setIgnored(false);
        }
    }

    private void collectFacetExtractors(Predicate predicate, Map<FacetExtractor, List<Predicate>> extractors, EvaluationContext context) {
        if (predicate instanceof PredicateGroup) {
            PredicateGroup group = (PredicateGroup)predicate;
            for (Predicate child : group) {
                this.collectFacetExtractors(child, extractors, context);
            }
        } else {
            FacetExtractor extractor;
            PredicateEvaluator evaluator = this.getPredicateEvaluator(predicate.getType());
            if (evaluator != null && (extractor = evaluator.getFacetExtractor(predicate, context)) != null) {
                if (extractors.containsKey(extractor)) {
                    extractors.get(extractor).add(predicate);
                } else {
                    ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                    predicates.add(predicate);
                    extractors.put(extractor, predicates);
                }
            }
        }
    }
}

