/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.impl.misc;

import com.day.cq.search.impl.misc.Excerpt;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Row;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExcerptsMap
extends AbstractMap<String, String> {
    private Set<Map.Entry<String, String>> entries = new HashSet<Map.Entry<String, String>>();

    public ExcerptsMap(Row row, Session session) throws RepositoryException {
        Node node;
        Item item = session.getItem(row.getValue("jcr:path").getString());
        if (item.isNode() && (node = (Node)item).hasNode("jcr:content")) {
            this.entries.add(new Entry(".", row));
            node = node.getNode("jcr:content");
            PropertyIterator it = node.getProperties();
            while (it.hasNext()) {
                Property p = it.nextProperty();
                if (p.getType() != 1) continue;
                this.entries.add(new Entry(p.getName(), row));
            }
        }
        this.entries = Collections.unmodifiableSet(this.entries);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.entries;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Entry
    implements Map.Entry<String, String> {
        private final String name;
        private final Row row;

        public Entry(String name, Row row) {
            this.name = name;
            this.row = row;
        }

        @Override
        public String getKey() {
            return this.name;
        }

        @Override
        public String getValue() {
            try {
                Value v;
                String path = "jcr:content";
                if (!this.name.equals(".")) {
                    path = path + "/" + this.name;
                }
                if ((v = this.row.getValue("rep:excerpt(" + path + ")")) != null) {
                    return Excerpt.getFirstSpan(v.getString());
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public String setValue(String s) {
            throw new UnsupportedOperationException();
        }
    }
}

