/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.impl.result;

import com.day.cq.search.impl.builder.QueryImpl;
import com.day.cq.search.impl.misc.Excerpt;
import com.day.cq.search.impl.misc.ExcerptsMap;
import com.day.cq.search.result.Hit;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.Row;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HitImpl
implements Hit {
    private final QueryImpl query;
    private final Row row;
    private final long index;
    private Map<String, String> excerpts;

    public HitImpl(QueryImpl query, Row row, long index) {
        this.query = query;
        this.row = row;
        this.index = index;
    }

    @Override
    public long getIndex() {
        return this.index;
    }

    @Override
    public Map<String, String> getExcerpts() throws RepositoryException {
        if (this.excerpts == null) {
            this.excerpts = new ExcerptsMap(this.row, this.query.getSession());
        }
        return this.excerpts;
    }

    @Override
    public String getExcerpt() throws RepositoryException {
        return Excerpt.create(this, this.query.getExcerptPropertyNames(), 150).getText();
    }

    @Override
    public Resource getResource() throws RepositoryException {
        ResourceResolver resolver = this.query.getResourceResolver();
        return resolver.getResource(this.getPath());
    }

    @Override
    public Node getNode() throws RepositoryException {
        return (Node)this.query.getSession().getItem(this.getPath());
    }

    @Override
    public String getPath() throws RepositoryException {
        return this.row.getValue("jcr:path").getString();
    }

    @Override
    public ValueMap getProperties() throws RepositoryException {
        Resource resource = this.getResource();
        if (resource != null) {
            Resource contentResource = resource.getResourceResolver().getResource(resource, "jcr:content");
            if (contentResource == null) {
                contentResource = resource;
            }
            return (ValueMap)contentResource.adaptTo(ValueMap.class);
        }
        return ValueMap.EMPTY;
    }

    @Override
    public String getTitle() throws RepositoryException {
        String excerpt = this.getExcerpts().get("jcr:title");
        if (excerpt != null) {
            return excerpt;
        }
        return ((Node)this.getResource().adaptTo(Node.class)).getName();
    }

    public Row getRow() {
        return this.row;
    }
}

