/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.impl.servlets;

import com.day.cq.commons.Externalizer;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import java.io.IOException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.abdera.Abdera;
import org.apache.abdera.ext.media.MediaExtensionFactory;
import org.apache.abdera.ext.opensearch.OpenSearchConstants;
import org.apache.abdera.ext.opensearch.model.IntegerElement;
import org.apache.abdera.ext.opensearch.model.OpenSearchExtensionFactory;
import org.apache.abdera.factory.ExtensionFactory;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.AtomDate;
import org.apache.abdera.model.Feed;
import org.apache.abdera.parser.stax.FOMFactory;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;

public class QueryBuilderFeedServlet
extends SlingAllMethodsServlet {
    protected QueryBuilder queryBuilder;
    protected Externalizer linkExternalizer;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.handleQuery(request, response);
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.handleQuery(request, response);
    }

    private void handleQuery(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        Map<String, String> paramMap;
        response.setContentType("application/atom+xml");
        response.setCharacterEncoding("utf-8");
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        StringBuilder pathWithParam = new StringBuilder(request.getRequestURI());
        String cookieName = request.getParameter("cookie");
        if (cookieName != null) {
            try {
                String[] params;
                paramMap = new HashMap();
                String cookieValue = request.getCookie(cookieName).getValue();
                for (String param1 : params = URLDecoder.decode(cookieValue).split("&")) {
                    String[] param = param1.split("=");
                    if (param.length != 2) continue;
                    String name = URLDecoder.decode(param[0], "UTF-8");
                    String value = URLDecoder.decode(param[1], "UTF-8");
                    paramMap.put(name, value);
                }
                pathWithParam.append("?").append(cookieValue);
            }
            catch (Exception e) {
                paramMap = request.getParameterMap();
                pathWithParam.append("?").append(request.getQueryString());
            }
        } else {
            paramMap = request.getParameterMap();
            pathWithParam.append("?").append(request.getQueryString());
        }
        Query query = this.queryBuilder.createQuery(PredicateGroup.create(paramMap), session);
        SearchResult result = query.getResult();
        ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            Abdera abdera = new Abdera();
            new FOMFactory();
            Factory f = abdera.getFactory();
            if (f instanceof FOMFactory) {
                FOMFactory ff = (FOMFactory)f;
                ff.registerExtension((ExtensionFactory)new MediaExtensionFactory());
                ff.registerExtension((ExtensionFactory)new OpenSearchExtensionFactory());
            }
            Feed feed = abdera.newFeed();
            Thread.currentThread().setContextClassLoader(previousClassLoader);
            request.setAttribute("abdera", (Object)abdera);
            request.setAttribute("feed", (Object)feed);
            String feedName = request.getParameter("p.feedname");
            feed.setTitle(feedName != null ? feedName : "CQ Feed");
            String url = this.linkExternalizer.absoluteLink(request, request.getScheme(), pathWithParam.toString());
            feed.setId(IRI.normalizeString((String)url));
            feed.addLink(url, "self");
            feed.setUpdated(new AtomDate(new Date()).getValue());
            IntegerElement itemsperpage = (IntegerElement)feed.addExtension(OpenSearchConstants.ITEMS_PER_PAGE);
            itemsperpage.setValue((int)result.getHitsPerPage());
            IntegerElement totalresults = (IntegerElement)feed.addExtension(OpenSearchConstants.TOTAL_RESULTS);
            totalresults.setValue((int)result.getTotalMatches());
            IntegerElement startindex = (IntegerElement)feed.addExtension(OpenSearchConstants.START_INDEX);
            startindex.setValue((int)result.getStartIndex());
            for (Hit hit : result.getHits()) {
                Object oldhit = request.getAttribute("hit");
                request.setAttribute("hit", (Object)hit);
                RequestDispatcher disp = request.getRequestDispatcher(hit.getPath() + ".feedentry");
                disp.include((ServletRequest)request, (ServletResponse)response);
                request.setAttribute("hit", oldhit);
            }
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            response.setContentType("application/atom+xml");
            response.setCharacterEncoding("utf-8");
            feed.writeTo((Writer)response.getWriter());
        }
        catch (RepositoryException e) {
            throw new ServletException("Error reading result of querybuilder", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousClassLoader);
        }
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }

    protected void bindLinkExternalizer(Externalizer externalizer) {
        this.linkExternalizer = externalizer;
    }

    protected void unbindLinkExternalizer(Externalizer externalizer) {
        if (this.linkExternalizer == externalizer) {
            this.linkExternalizer = null;
        }
    }
}

