/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.writer;

import com.day.cq.search.Query;
import com.day.cq.search.result.Hit;
import com.day.cq.search.writer.ResultHitWriter;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.apache.sling.commons.json.jcr.JsonItemWriter;

public class FullNodeHitWriter
implements ResultHitWriter {
    public void write(Hit hit, JSONWriter writer, Query query) throws RepositoryException, JSONException {
        int maxRecursionLevels = Integer.parseInt(query.getPredicates().get("nodedepth", "0"));
        boolean writeACLs = query.getPredicates().getBool("acls");
        writer.key("jcr:path").value((Object)hit.getPath());
        new JsonNodeDumper(writeACLs).dumpObject(hit.getNode(), writer, 0, maxRecursionLevels);
    }

    private static class JsonNodeDumper
    extends JsonItemWriter {
        private boolean writeACLs = false;

        public JsonNodeDumper(boolean writeACLs) {
            super(null);
            this.writeACLs = writeACLs;
        }

        protected void dump(Node node, JSONWriter w, int currentRecursionLevel, int maxRecursionLevels) throws RepositoryException, JSONException {
            w.object();
            this.dumpObject(node, w, currentRecursionLevel, maxRecursionLevels);
            w.endObject();
        }

        public void dumpObject(Node node, JSONWriter w, int currentRecursionLevel, int maxRecursionLevels) throws RepositoryException, JSONException {
            PropertyIterator props = node.getProperties();
            if (this.writeACLs) {
                this.writeACL(node, w);
            }
            while (props.hasNext()) {
                this.writeProperty(w, props.nextProperty());
            }
            if (this.recursionLevelActive(currentRecursionLevel, maxRecursionLevels)) {
                NodeIterator children = node.getNodes();
                while (children.hasNext()) {
                    Node n = children.nextNode();
                    this.dumpSingleNode(n, w, currentRecursionLevel, maxRecursionLevels);
                }
            }
        }

        protected void writeACL(Node node, JSONWriter w) throws RepositoryException, JSONException {
            Session session = node.getSession();
            w.key("jcr:permissions").object();
            w.key("create").value(session.hasPermission(node.getPath() + "/newnode", "add_node"));
            w.key("modify").value(session.hasPermission(node.getPath() + "/newprop", "set_property"));
            w.key("delete").value(session.hasPermission(node.getPath(), "remove"));
            w.endObject();
        }
    }
}

