/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.searchpromote.impl;

import com.day.cq.searchpromote.SearchPromoteException;
import com.day.cq.searchpromote.SearchPromoteService;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Dictionary;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchPromoteServiceImpl
implements SearchPromoteService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String SERVER_URI = "cq.searchpromote.configuration.server.uri";
    private URI serverUri;

    public URI getServerURI() {
        return this.serverUri;
    }

    public String getSearchForm(String memberid, String accountnumber) throws SearchPromoteException {
        return this.executeMethod((HttpMethod)new GetMethod(this.serverUri.toString() + "/searchform/?sp_id=" + memberid + "-" + accountnumber + "&sp_fn=xml"));
    }

    public String getFacetList(String memberid, String accountnumber) throws SearchPromoteException {
        return this.executeMethod((HttpMethod)new GetMethod(this.serverUri.toString() + "/design/?sp_id=" + memberid + "-" + accountnumber + "&sp_fn=facets"));
    }

    private String executeMethod(HttpMethod method) throws SearchPromoteException {
        HttpClient client = new HttpClient();
        try {
            Integer status = client.executeMethod(method);
            if (status != 200) {
                String string = null;
                return string;
            }
            String string = method.getResponseBodyAsString();
            return string;
        }
        catch (UnknownHostException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new SearchPromoteException("Unknown host: " + e.getMessage(), e);
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new SearchPromoteException(e.getMessage(), e);
        }
        finally {
            method.releaseConnection();
        }
    }

    protected void activate(ComponentContext componentContext) {
        this.log.debug("Starting SearchPromoteConfiguration...");
        Dictionary properties = componentContext.getProperties();
        String uri = OsgiUtil.toString(properties.get(SERVER_URI), (String)"");
        if (uri.endsWith("/")) {
            uri = uri.substring(0, uri.lastIndexOf("/"));
        }
        try {
            this.serverUri = new URI(uri);
        }
        catch (URISyntaxException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        this.log.debug("...SearchPromoteConfiguration started");
    }

    protected void deactivate(ComponentContext componentContext) {
        this.log.debug("Stopping SearchPromoteConfiguration...");
        this.log.debug("...SearchPromoteConfiguration stopped");
    }

    public String getBannerAreaList(String memberid, String accountnumber) throws SearchPromoteException {
        return this.executeMethod((HttpMethod)new GetMethod(this.serverUri + "/design/?sp_id=" + memberid + "-" + accountnumber + "&sp_fn=bannerareas"));
    }
}

