/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.searchpromote.impl.servlet;

import com.day.cq.searchpromote.SearchPromoteService;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacetListServlet
extends SlingAllMethodsServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ConfigurationManager configManager;
    private SearchPromoteService searchpromote;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Configuration config = null;
        try {
            config = this.getConfiguration(request, "search-promote");
        }
        catch (Exception e) {
            this.log.error("Could not get configuration", (Throwable)e);
        }
        String memberId = (String)config.get("memberid", (Object)"");
        String accountNo = (String)config.get("accountno", (Object)"");
        PrintWriter out = response.getWriter();
        JSONWriter writer = new JSONWriter((Writer)out);
        try {
            String facetList = this.searchpromote.getFacetList(memberId, accountNo);
            JSONObject facets = new JSONObject(facetList);
            ((Writer)out).write(facets.toString());
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            try {
                writer.object();
                writer.endObject();
            }
            catch (JSONException ignored) {
                this.log.error(ignored.getMessage(), (Throwable)ignored);
            }
        }
        finally {
            ((Writer)out).flush();
        }
    }

    private Configuration getConfiguration(SlingHttpServletRequest request, String servicename) throws RepositoryException {
        ResourceResolver resolver;
        PageManager pageManager;
        Page currentPage;
        Resource configRes;
        String pagePath = request.getResource().getPath();
        if (pagePath.indexOf("/jcr:content") > -1) {
            pagePath = pagePath.substring(0, pagePath.indexOf("/jcr:content"));
        }
        if ((configRes = this.configManager.getConfigurationResource((currentPage = (pageManager = (PageManager)(resolver = request.getResource().getResourceResolver()).adaptTo(PageManager.class)).getPage(pagePath)).getContentResource())) != null) {
            String configPath = this.getConfigurationPath(configRes, servicename);
            return this.configManager.getConfiguration(configPath);
        }
        return null;
    }

    private String getConfigurationPath(Resource resource, String servicename) throws RepositoryException {
        Resource cloudconfigsContent = resource.getChild("jcr:content");
        Node cloudconfigsNode = (Node)cloudconfigsContent.adaptTo(Node.class);
        Property prop = cloudconfigsNode.getProperty("cq:cloudserviceconfigs");
        String configPath = null;
        if (prop.isMultiple()) {
            for (Value val : prop.getValues()) {
                String path = val.getString();
                if (path == null || path.indexOf(servicename) <= -1) continue;
                configPath = path;
            }
        } else {
            String path = prop.getValue().getString();
            if (path != null && path.indexOf(servicename) > -1) {
                configPath = path;
            }
        }
        return configPath;
    }

    protected void bindConfigManager(ConfigurationManager configurationManager) {
        this.configManager = configurationManager;
    }

    protected void unbindConfigManager(ConfigurationManager configurationManager) {
        if (this.configManager == configurationManager) {
            this.configManager = null;
        }
    }

    protected void bindSearchpromote(SearchPromoteService searchPromoteService) {
        this.searchpromote = searchPromoteService;
    }

    protected void unbindSearchpromote(SearchPromoteService searchPromoteService) {
        if (this.searchpromote == searchPromoteService) {
            this.searchpromote = null;
        }
    }
}

