/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.searchpromote.impl.servlet;

import com.day.cq.searchpromote.SearchPromoteException;
import com.day.cq.searchpromote.SearchPromoteService;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchFormServlet
extends SlingAllMethodsServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String PARAM_MEMBERID = "memberid";
    private static final String PARAM_ACCOUNTNO = "accountno";
    private SearchPromoteService searchpromote;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String memberId = request.getParameter(PARAM_MEMBERID);
        String accountNo = request.getParameter(PARAM_ACCOUNTNO);
        PrintWriter out = response.getWriter();
        JSONWriter writer = new JSONWriter((Writer)out);
        try {
            String searchformXml = this.searchpromote.getSearchForm(memberId, accountNo);
            if (searchformXml == null || searchformXml.endsWith("html>")) {
                this.log.warn("Search form XML could not be found for {}-{}", (Object)memberId, (Object)accountNo);
                throw new SearchPromoteException("Credentials invalid");
            }
            writer.object();
            writer.key("xml").value((Object)StringEscapeUtils.escapeXml((String)searchformXml));
            writer.endObject();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            try {
                writer.object();
                writer.key("error").value((Object)e.getMessage());
                writer.endObject();
            }
            catch (JSONException ignored) {
                this.log.error(ignored.getMessage(), (Throwable)ignored);
            }
        }
        finally {
            ((Writer)out).flush();
        }
    }

    protected void bindSearchpromote(SearchPromoteService searchPromoteService) {
        this.searchpromote = searchPromoteService;
    }

    protected void unbindSearchpromote(SearchPromoteService searchPromoteService) {
        if (this.searchpromote == searchPromoteService) {
            this.searchpromote = null;
        }
    }
}

