/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.statistics.query;

import com.day.crx.statistics.PathBuilder;
import com.day.crx.statistics.Report;
import com.day.crx.statistics.query.Query;
import com.day.crx.statistics.query.QueryPathBuilder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

public class MostPopularQueriesReport
extends Report {
    static final String CVS_ID = "$URL: http://svn.day.com/repos/misc/crx-statistics/tags/crx-statistics-1.4.2/src/main/java/com/day/crx/statistics/query/MostPopularQueriesReport.java $ $Rev: 37633 $ $Date: 2008-07-09 14:48:38 +0200 (Mi, 09 Jul 2008) $";
    private static final long ONE_DAY = 86400000L;
    private int size = 10;
    private long endDate = System.currentTimeMillis();
    private int period = 30;

    public MostPopularQueriesReport(String dataPath) {
        super(dataPath);
    }

    public Iterator getResult(Session session) throws RepositoryException {
        long startDate = this.getStartDate();
        HashMap<String, Long> queries = new HashMap<String, Long>();
        QueryPathBuilder builder = new QueryPathBuilder();
        Query dummy = new Query(this.getDataPath(), "dummy", 0L, 0L);
        StringBuffer path = new StringBuffer();
        for (long date = startDate; date <= this.endDate; date += 86400000L) {
            path.setLength(0);
            dummy.setTimestamp(date);
            ((PathBuilder)builder).formatPath(dummy, path);
            path.setLength(path.lastIndexOf("/"));
            if (!session.itemExists(path.toString())) continue;
            NodeIterator nodes = ((Node)session.getItem(path.toString())).getNodes();
            while (nodes.hasNext()) {
                Node qn = nodes.nextNode();
                String query = qn.getName();
                long count = qn.getProperty("count").getLong();
                Long c = (Long)queries.get(query);
                if (c != null) {
                    count += c.longValue();
                }
                queries.put(query, new Long(count));
            }
        }
        List result = new ArrayList<Object[]>();
        Iterator entries = queries.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            result.add(new Object[]{entry.getKey(), entry.getValue()});
        }
        Collections.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                Object[] e2 = (Object[])o2;
                Object[] e1 = (Object[])o1;
                int comp = ((Comparable)e2[1]).compareTo(e1[1]);
                if (comp != 0) {
                    return comp;
                }
                return ((String)e1[0]).toLowerCase().compareTo(((String)e2[0]).toLowerCase());
            }
        });
        result = result.subList(0, Math.min(this.getSize(), result.size()));
        return result.iterator();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public long getStartDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.getEndDate());
        cal.add(5, -(this.getPeriod() - 1));
        return cal.getTimeInMillis();
    }

    public void setEndDate(long end) {
        this.endDate = end;
    }

    public long getEndDate() {
        return this.endDate;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }
}

