/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.statistics.result;

import com.day.crx.statistics.JanitorReport;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import org.apache.jackrabbit.util.ISO9075;

public class RemoveOldResultsReport
extends JanitorReport {
    static final String CVS_ID = "$URL: http://svn.day.com/repos/misc/crx-statistics/tags/crx-statistics-1.4.2/src/main/java/com/day/crx/statistics/result/RemoveOldResultsReport.java $ $Rev: 36370 $ $Date: 2008-06-04 13:39:38 +0200 (Mi, 04 Jun 2008) $";

    public RemoveOldResultsReport(String dataPath, boolean dryRun) {
        super(dataPath, dryRun);
    }

    public Iterator getResult(Session session) throws RepositoryException {
        TreeSet<String> removable = new TreeSet<String>(new Comparator(){

            public int compare(Object o1, Object o2) {
                String[] p1 = this.split((String)o1);
                String[] p2 = this.split((String)o2);
                int c = p2[1].compareTo(p1[1]);
                if (c != 0) {
                    return c;
                }
                return p1[0].compareTo(p2[0]);
            }

            private String[] split(String path) {
                String[] parts = new String[2];
                int idx = path.indexOf("/.stats/");
                parts[0] = path.substring(0, idx);
                parts[1] = path.substring(idx + ".stats".length() + 2);
                return parts;
            }
        });
        QueryManager qm = session.getWorkspace().getQueryManager();
        StringBuffer stmt = new StringBuffer("/jcr:root");
        stmt.append(this.getDataPath()).append("//");
        stmt.append(ISO9075.encode((String)".stats"));
        NodeIterator stats = qm.createQuery(stmt.toString(), "xpath").execute().getNodes();
        Calendar cal = Calendar.getInstance();
        while (stats.hasNext()) {
            Node s = stats.nextNode();
            NodeIterator years = s.getNodes();
            while (years.hasNext()) {
                Node y = years.nextNode();
                cal.set(1, Integer.parseInt(y.getName()));
                NodeIterator months = y.getNodes();
                while (months.hasNext()) {
                    Node m = months.nextNode();
                    cal.set(2, Integer.parseInt(m.getName()) - 1);
                    if (cal.getTimeInMillis() < this.getMonthThresholdDate()) {
                        removable.add(m.getPath());
                        continue;
                    }
                    NodeIterator days = m.getNodes();
                    while (days.hasNext()) {
                        Node d = days.nextNode();
                        cal.set(5, Integer.parseInt(d.getName()));
                        if (cal.getTimeInMillis() >= this.getDayThresholdDate()) continue;
                        removable.add(d.getPath());
                    }
                }
            }
        }
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        Iterator it = removable.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            if (!this.isDryRun()) {
                session.getItem(path).remove();
            }
            result.add(new Object[]{path});
        }
        if (!this.isDryRun()) {
            session.save();
        }
        return result.iterator();
    }
}

