/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.statistics.query;

import com.day.crx.statistics.JanitorReport;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

public class RemoveOldQueriesReport
extends JanitorReport {
    static final String CVS_ID = "$URL: http://svn.day.com/repos/misc/crx-statistics/tags/crx-statistics-1.4.2/src/main/java/com/day/crx/statistics/query/RemoveOldQueriesReport.java $ $Rev: 37633 $ $Date: 2008-07-09 14:48:38 +0200 (Mi, 09 Jul 2008) $";

    public RemoveOldQueriesReport(String dataPath, boolean dryRun) {
        super(dataPath, dryRun);
    }

    public Iterator getResult(Session session) throws RepositoryException {
        TreeSet removable = new TreeSet(Collections.reverseOrder());
        Calendar cal = Calendar.getInstance();
        Node data = this.getDataNode(session);
        if (data == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        NodeIterator years = data.getNodes();
        while (years.hasNext()) {
            Node y = years.nextNode();
            cal.set(1, Integer.parseInt(y.getName()));
            NodeIterator months = y.getNodes();
            while (months.hasNext()) {
                Node m = months.nextNode();
                cal.set(2, Integer.parseInt(m.getName()) - 1);
                if (cal.getTimeInMillis() < this.getMonthThresholdDate()) {
                    removable.add(m.getPath());
                    continue;
                }
                NodeIterator days = m.getNodes();
                while (days.hasNext()) {
                    Node d = days.nextNode();
                    cal.set(5, Integer.parseInt(d.getName()) - 1);
                    if (cal.getTimeInMillis() >= this.getDayThresholdDate()) continue;
                    removable.add(d.getPath());
                }
            }
        }
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        Iterator it = removable.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            if (!this.isDryRun()) {
                session.getItem(path).remove();
            }
            result.add(new Object[]{path});
        }
        if (!this.isDryRun()) {
            session.save();
        }
        return result.iterator();
    }
}

