/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.statistics.impl;

import com.day.cq.statistics.StatisticsService;
import com.day.crx.statistics.Entry;
import com.day.crx.statistics.Report;
import com.day.crx.statistics.Statistics;
import com.day.crx.statistics.keyword.ExtractKeywordsReport;
import com.day.crx.statistics.keyword.KeywordsReport;
import com.day.crx.statistics.query.RemoveOldQueriesReport;
import com.day.crx.statistics.result.RemoveOldResultsReport;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsServiceImpl
implements StatisticsService,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(StatisticsServiceImpl.class);
    private static final String PROPERTY_LAST_CLEANUP_DATE = "lastCleanUpDate";
    protected static final String CONFIG_PROPERTY_PATH = "path";
    protected static final String CONFIG_PROPERTY_WORKSPACE = "workspace";
    protected static final String CONFIG_PROPERTY_KEYWORDS_PATH = "keywordsPath";
    private SlingRepository repository;
    private String path;
    private String workspaceName;
    private String keywordsPath;
    private Statistics statistics;

    protected void activate(ComponentContext context) throws RepositoryException {
        this.path = (String)context.getProperties().get(CONFIG_PROPERTY_PATH);
        this.workspaceName = (String)context.getProperties().get(CONFIG_PROPERTY_WORKSPACE);
        this.keywordsPath = (String)context.getProperties().get(CONFIG_PROPERTY_KEYWORDS_PATH);
        this.statistics = new Statistics(this.repository.loginAdministrative(this.workspaceName));
    }

    protected void deactivate(ComponentContext context) {
        if (this.statistics != null) {
            this.statistics.stop();
        }
    }

    public Iterator runReport(Report report) throws RepositoryException {
        return this.statistics.runReport(report);
    }

    public void addEntry(Entry entry) throws RepositoryException {
        this.statistics.addEntry(entry);
    }

    public String getPath() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            log.debug("Checking for statistics clean up and keywords update");
            Session s = this.repository.loginAdministrative(this.workspaceName);
            try {
                if (!s.itemExists(this.path)) {
                    return;
                }
                Item item = s.getItem(this.path);
                if (item.isNode()) {
                    Node stats = (Node)item;
                    if (stats.hasProperty(PROPERTY_LAST_CLEANUP_DATE)) {
                        Calendar next = Calendar.getInstance();
                        next.setTimeInMillis(stats.getProperty(PROPERTY_LAST_CLEANUP_DATE).getDate().getTimeInMillis());
                        next.add(5, 1);
                        if (System.currentTimeMillis() < next.getTimeInMillis()) {
                            return;
                        }
                    }
                    this.cleanUpStatistics();
                    this.updateKeywords(s);
                    stats.setProperty(PROPERTY_LAST_CLEANUP_DATE, Calendar.getInstance());
                    s.save();
                }
            }
            finally {
                s.logout();
            }
        }
        catch (Exception e) {
            log.warn("Exception while cleaning up", (Throwable)e);
        }
    }

    private void cleanUpStatistics() throws RepositoryException {
        log.info("Running clean up reports...");
        this.statistics.runReport(new RemoveOldQueriesReport(this.getPath() + "/queries", false));
        this.statistics.runReport(new RemoveOldResultsReport(this.getPath() + "/results", false));
        log.info("Clean up reports finished");
    }

    private void updateKeywords(Session s) throws RepositoryException {
        Object[] keywords;
        log.info("Running keyword update report...");
        KeywordsReport kr = new KeywordsReport("", this.keywordsPath);
        HashMap<String, String[]> current = new HashMap<String, String[]>();
        Iterator it = kr.getResult(s);
        while (it.hasNext()) {
            Object[] data = (Object[])it.next();
            current.put((String)data[0], (String[])data[1]);
        }
        ExtractKeywordsReport ekr = new ExtractKeywordsReport(this.getPath() + "/queries", this.getPath() + "/results");
        int updated = 0;
        int added = 0;
        Iterator it2 = this.runReport(ekr);
        while (it2.hasNext()) {
            Item item;
            String modifier;
            Object[] data = (Object[])it2.next();
            String path = (String)data[0];
            if (!s.itemExists(path)) continue;
            List kw = (List)data[2];
            keywords = kw.toArray(new String[kw.size()]);
            Object[] currentKeywords = (String[])current.remove(path);
            StringBuffer sb = new StringBuffer();
            if (currentKeywords != null) {
                sb.append("'");
                sb.append(Text.implode((String[])currentKeywords, (String)"', '"));
                sb.append("'");
                if (Arrays.equals(currentKeywords, keywords)) continue;
                modifier = "U";
                sb.append(" -> '");
                sb.append(Text.implode((String[])keywords, (String)"', '"));
                sb.append("'");
                item = s.getItem(path + "/" + this.keywordsPath);
                if (!item.isNode()) {
                    ((Property)item).setValue((String[])keywords);
                }
                ++updated;
            } else {
                modifier = "A";
                sb.append("'");
                sb.append(Text.implode((String[])keywords, (String)"', '"));
                sb.append("'");
                item = s.getItem(path);
                if (item.isNode()) {
                    Node n = (Node)item;
                    if (this.keywordsPath.indexOf(47) != -1) {
                        n = n.getNode(Text.getRelativeParent((String)this.keywordsPath, (int)1));
                        n.setProperty(Text.getName((String)this.keywordsPath), (String[])keywords);
                    } else {
                        n.setProperty(this.keywordsPath, (String[])keywords);
                    }
                }
                ++added;
            }
            log.info("{} {} [{}]", new Object[]{modifier, path, sb});
        }
        int deleted = current.size();
        for (Map.Entry entry : current.entrySet()) {
            String path = (String)entry.getKey();
            keywords = (String[])entry.getValue();
            StringBuffer sb = new StringBuffer("'");
            sb.append(Text.implode((String[])keywords, (String)"', '"));
            sb.append("'");
            Item item = s.getItem(path);
            if (item.isNode()) {
                ((Node)item).getProperty(this.keywordsPath).remove();
            }
            log.info("D {} [{}]", new Object[]{path, sb});
        }
        if (s.hasPendingChanges()) {
            log.info("Updated: {}, added: {}, deleted: {}", new Object[]{updated, added, deleted});
        } else {
            log.info("No keyword properties modified");
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

