/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.statistics.keyword;

import com.day.crx.statistics.Report;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.QueryManager;
import org.apache.jackrabbit.util.Text;

public class KeywordsReport
extends Report {
    static final String CVS_ID = "$URL:$ $Rev:$ $Date:$";
    private final String keywordRelPath;

    public KeywordsReport(String dataPath, String keywordRelPath) {
        super(dataPath);
        this.keywordRelPath = keywordRelPath;
    }

    public Iterator getResult(Session session) throws RepositoryException {
        QueryManager qm = session.getWorkspace().getQueryManager();
        StringBuffer stmt = new StringBuffer("/jcr:root");
        stmt.append(this.getDataPath());
        stmt.append("//*[");
        String[] parts = Text.explode((String)this.keywordRelPath, (int)47);
        String separator = "";
        for (int i = 0; i < parts.length; ++i) {
            stmt.append(separator);
            if (i == parts.length - 1) {
                stmt.append("@");
            }
            stmt.append(parts[i]);
            separator = "/";
        }
        stmt.append("]");
        NodeIterator nodes = qm.createQuery(stmt.toString(), "xpath").execute().getNodes();
        ArrayList<Object[]> paths = new ArrayList<Object[]>();
        while (nodes.hasNext()) {
            Node n = nodes.nextNode();
            Value[] values = n.hasProperty(this.keywordRelPath) ? n.getProperty(this.keywordRelPath).getValues() : new Value[]{};
            String[] keywords = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                keywords[i] = values[i].getString();
            }
            paths.add(new Object[]{n.getPath(), keywords});
        }
        return paths.iterator();
    }
}

