/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.statistics.result;

import com.day.crx.statistics.Entry;
import com.day.crx.statistics.PathBuilder;
import com.day.crx.statistics.result.ResultSelectedPathBuilder;
import java.util.ArrayList;
import java.util.Calendar;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;

public class ResultSelected
extends Entry {
    static final String CVS_ID = "$URL: http://svn.day.com/repos/misc/crx-statistics/tags/crx-statistics-1.4.2/src/main/java/com/day/crx/statistics/result/ResultSelected.java $ $Rev: 37633 $ $Date: 2008-07-09 14:48:38 +0200 (Mi, 09 Jul 2008) $";
    public static final String COUNT = "count";
    public static final String ROLLING_WEEK_COUNT = "rollingWeekCount";
    public static final String ROLLING_MONTH_COUNT = "rollingMonthCount";
    public static final String AVG_POSITION = "avgPosition";
    public static final String QUERIES = "queries";
    private static final int MAX_REMEMBERED_QUERIES = 10;
    private final String path;
    private final long position;
    private final String query;

    public ResultSelected(String pathPrefix, String path, long position, String query) {
        super(pathPrefix);
        this.path = path;
        this.position = position;
        this.query = query;
    }

    protected PathBuilder getPathBuilder() {
        return new ResultSelectedPathBuilder();
    }

    public void write(Node node) throws RepositoryException {
        long count = this.updateCount(node);
        Node month = node.getParent();
        this.updateCount(month);
        Node year = month.getParent();
        this.updateCount(year);
        this.updateAveragePosition(node, count);
        this.updateCumulativeCount(node, ROLLING_WEEK_COUNT, 6);
        this.updateCumulativeCount(node, ROLLING_MONTH_COUNT, 29);
        this.updateQuery(node);
        this.updateQuery(month);
        this.updateQuery(year);
    }

    public String getResultPath() {
        return this.path;
    }

    private void updateQuery(Node node) throws RepositoryException {
        if (this.query == null) {
            return;
        }
        Value q = node.getSession().getValueFactory().createValue(this.query);
        ArrayList<Value> queries = new ArrayList<Value>();
        queries.add(q);
        if (node.hasProperty(QUERIES)) {
            Value[] values = node.getProperty(QUERIES).getValues();
            for (int i = 0; i < values.length && queries.size() < 10; ++i) {
                if (q.getString().equals(values[i].getString())) continue;
                queries.add(values[i]);
            }
        }
        node.setProperty(QUERIES, queries.toArray(new Value[queries.size()]));
    }

    private long updateCount(Node node) throws RepositoryException {
        long count = 0L;
        if (node.hasProperty(COUNT)) {
            count = node.getProperty(COUNT).getLong();
        }
        node.setProperty(COUNT, ++count);
        return count;
    }

    private double updateAveragePosition(Node node, long count) throws RepositoryException {
        double avgPosition = this.position;
        if (node.hasProperty(AVG_POSITION)) {
            avgPosition = node.getProperty(AVG_POSITION).getDouble();
        }
        avgPosition = (avgPosition * (double)(count - 1L) + (double)this.position) / (double)count;
        node.setProperty(AVG_POSITION, avgPosition);
        return avgPosition;
    }

    private long updateCumulativeCount(Node node, String propertyName, int numDays) throws RepositoryException {
        long count;
        if (node.hasProperty(propertyName)) {
            count = node.getProperty(propertyName).getLong();
        } else {
            count = 0L;
            Session session = node.getSession();
            PathBuilder builder = this.getPathBuilder();
            Calendar date = Calendar.getInstance();
            date.setTimeInMillis(this.getTimestamp());
            ResultSelected rs = new ResultSelected(this.getPathPrefix(), this.getResultPath(), 1L, "");
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < numDays; ++i) {
                buffer.setLength(0);
                date.add(5, -1);
                rs.setTimestamp(date.getTimeInMillis());
                builder.formatPath(rs, buffer);
                String path = buffer.toString();
                try {
                    Node n;
                    Item item = session.getItem(path);
                    if (!item.isNode() || !(n = (Node)item).hasProperty(COUNT)) continue;
                    count += n.getProperty(COUNT).getLong();
                    continue;
                }
                catch (PathNotFoundException e) {
                    // empty catch block
                }
            }
        }
        node.setProperty(propertyName, ++count);
        return count;
    }
}

