/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.statistics;

import com.day.crx.statistics.PathBuilder;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

public abstract class Entry {
    static final String CVS_ID = "$URL: http://svn.day.com/repos/misc/crx-statistics/tags/crx-statistics-1.4.2/src/main/java/com/day/crx/statistics/Entry.java $ $Rev: 36237 $ $Date: 2008-05-30 16:07:26 +0200 (Fr, 30 Mai 2008) $";
    private long timestamp = System.currentTimeMillis();
    private String pathPrefix;

    public Entry(String pathPrefix) {
        this.setPathPrefix(pathPrefix);
    }

    public final void write(Session session) throws RepositoryException {
        String path = this.getPath();
        String[] names = path.substring(1).split("/");
        Node node = session.getRootNode();
        for (int i = 0; i < names.length; ++i) {
            node = node.hasNode(names[i]) ? node.getNode(names[i]) : node.addNode(names[i]);
        }
        this.write(node);
    }

    public void write(Node node) throws RepositoryException {
        node.setProperty("timestamp", this.getTimestamp());
    }

    public final String getPath() {
        StringBuffer buffer = new StringBuffer();
        this.getPathBuilder().formatPath(this, buffer);
        return buffer.toString();
    }

    protected abstract PathBuilder getPathBuilder();

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public void setPathPrefix(String pathPrefix) {
        if (!pathPrefix.startsWith("/")) {
            pathPrefix = "/" + pathPrefix;
        }
        if (pathPrefix.equals("/")) {
            pathPrefix = "";
        }
        this.pathPrefix = pathPrefix;
    }
}

