/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.statistics.servlet;

import com.day.cq.statistics.StatisticsService;
import com.day.cq.statistics.util.RequestHelper;
import com.day.crx.statistics.query.Query;
import com.day.crx.statistics.result.ResultSelected;
import java.io.IOException;
import java.net.URI;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;

public class TrackerServlet
extends SlingSafeMethodsServlet {
    private StatisticsService statService;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            if (request.getRequestURI().endsWith("query")) {
                this.logQuery(request);
            } else if (request.getRequestURI().endsWith("result")) {
                this.logResult(request);
            }
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void logQuery(SlingHttpServletRequest request) throws RepositoryException {
        String query = RequestHelper.getStringParameter((HttpServletRequest)request, "q", null);
        long numResults = RequestHelper.getLongParameter((HttpServletRequest)request, "nr", -1L);
        long executionTime = RequestHelper.getLongParameter((HttpServletRequest)request, "et", -1L);
        if (query != null) {
            this.statService.addEntry(new Query(this.statService.getPath() + "/queries", query, numResults, executionTime));
        }
    }

    private void logResult(SlingHttpServletRequest request) throws RepositoryException {
        String path = RequestHelper.getStringParameter((HttpServletRequest)request, "p", null);
        long position = RequestHelper.getLongParameter((HttpServletRequest)request, "po", -1L);
        String query = RequestHelper.getStringParameter((HttpServletRequest)request, "q", null);
        if (path == null || path.length() == 0 || position == -1L) {
            return;
        }
        try {
            path = new URI(path).getPath();
            int extIdx = path.indexOf(46);
            if (extIdx != -1) {
                path = path.substring(0, extIdx);
            }
        }
        catch (Exception e) {
            return;
        }
        this.statService.addEntry(new ResultSelected(this.statService.getPath() + "/results", path, position, query));
    }

    protected void bindStatService(StatisticsService statisticsService) {
        this.statService = statisticsService;
    }

    protected void unbindStatService(StatisticsService statisticsService) {
        if (this.statService == statisticsService) {
            this.statService = null;
        }
    }
}

