<%@ page import="java.io.InputStream, java.util.zip.GZIPInputStream, com.day.crx.statistics.loader.AccessLogLoader, com.day.crx.statistics.Entry, javax.jcr.RepositoryException, java.io.IOException, com.day.cq.statistics.util.RequestHelper, org.apache.sling.api.request.RequestParameter" %>
<%@ include file="/libs/statistics/global.jspf"
%><html><head><title><c:out value="${properties['jcr:title']}"/></title><%
%></head><body><%
    if (request.getContentType().startsWith("multipart/")) {
        // query path prefix
        RequestParameter qpp = slingRequest.getRequestParameter("qpp");
        // query parameter name
        RequestParameter qpn = slingRequest.getRequestParameter("qpn");
        // result path prefix
        RequestParameter rpp = slingRequest.getRequestParameter("rpp");
        // access log file
        RequestParameter file = slingRequest.getRequestParameter("file");

        if (qpp == null || qpn == null || file == null) {
            return;
        }

        try {
            InputStream in = file.getInputStream();
            try {
                if (file.getFileName().endsWith("gz")) {
                    in = new GZIPInputStream(in);
                }
                AccessLogLoader loader = new AccessLogLoader(queryDataPath,
                        resultDataPath, qpp.getString(), qpn.getString(),
                        rpp.getString());
                loader.setProgressListener(new AccessLogLoader.ProgressListener() {
                    public void lineProcessed(int line, int queryCount,
                                              int resultCount, Entry entry) {
                        if (entry != null) {
                            try {
                                statService.addEntry(entry);
                            } catch (RepositoryException e) {
                                // ignore
                            }
                        }
                    }
                });
                loader.processFile(in);
            } finally {
                in.close();
            }
        } catch (Exception e) {
            e.printStackTrace(new java.io.PrintWriter(out));
        }
    }
%></body></html>