/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.testing.httpserver;

import com.day.cq.testing.socket.RandomPortSelector;
import java.io.File;
import java.io.IOException;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.SocketListener;
import org.mortbay.http.handler.ResourceHandler;
import org.mortbay.jetty.Server;

public class EmbeddedHttpServer {
    private final Server server = new Server();
    private final int port;

    public EmbeddedHttpServer(File docroot) throws IOException {
        this(docroot, new RandomPortSelector().getRandomServerPortNumber());
    }

    public EmbeddedHttpServer(File docroot, int port) throws IOException {
        SocketListener listener = new SocketListener();
        listener.setPort(port);
        this.server.addListener((HttpListener)listener);
        HttpContext context = new HttpContext();
        context.setContextPath("/");
        context.setResourceBase(docroot.getAbsolutePath());
        context.addHandler((HttpHandler)new ResourceHandler());
        this.server.addContext(context);
        this.port = port;
    }

    public void start(boolean autoStopAtVmShutdown) throws Exception {
        if (!this.server.isStarted()) {
            this.server.start();
            if (autoStopAtVmShutdown) {
                Runtime.getRuntime().addShutdownHook(new ShutdownThread());
            }
        }
    }

    public void stop() throws Exception {
        if (this.server.isStarted()) {
            this.server.stop();
        }
    }

    public int getServerPort() {
        return this.port;
    }

    private class ShutdownThread
    extends Thread {
        private ShutdownThread() {
        }

        public void run() {
            try {
                EmbeddedHttpServer.this.stop();
            }
            catch (Exception e) {
                System.err.println("Exception in " + this.getClass().getName() + ": " + e);
            }
        }
    }
}

