/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.testing.sling;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.adapter.internal.AdapterManagerTestHelper;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.testing.jcr.RepositoryUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.apache.sling.jcr.resource.internal.JcrResourceResolverFactoryImpl;
import org.apache.sling.jcr.resource.internal.helper.Mapping;

public class SlingTestHelper {
    public static JcrResourceResolverFactory getJcrResourceResolverFactory(SlingRepository repository) throws Exception {
        JcrResourceResolverFactoryImpl resFac = new JcrResourceResolverFactoryImpl();
        Field repoField = resFac.getClass().getDeclaredField("repository");
        repoField.setAccessible(true);
        repoField.set(resFac, repository);
        Field mappingsField = resFac.getClass().getDeclaredField("mappings");
        mappingsField.setAccessible(true);
        mappingsField.set(resFac, new Mapping[]{Mapping.DIRECT});
        Field searchPathField = resFac.getClass().getDeclaredField("searchPath");
        searchPathField.setAccessible(true);
        searchPathField.set(resFac, new String[]{"/apps", "/libs"});
        return resFac;
    }

    public static ResourceResolver getResourceResolver(SlingRepository repository, Session session) throws Exception {
        JcrResourceResolverFactory factory = SlingTestHelper.getJcrResourceResolverFactory(repository);
        return factory.getResourceResolver(session);
    }

    public static void registerSlingNodeTypes(Session adminSession) throws IOException, RepositoryException {
        Class<SlingTestHelper> clazz = SlingTestHelper.class;
        RepositoryUtil.registerNodeType((Session)adminSession, (InputStream)clazz.getResourceAsStream("/SLING-INF/nodetypes/folder.cnd"));
        RepositoryUtil.registerNodeType((Session)adminSession, (InputStream)clazz.getResourceAsStream("/SLING-INF/nodetypes/resource.cnd"));
        RepositoryUtil.registerNodeType((Session)adminSession, (InputStream)clazz.getResourceAsStream("/SLING-INF/nodetypes/vanitypath.cnd"));
    }

    public static void registerAdapterFactory(AdapterFactory adapterFactory, String[] adaptableClasses, String[] adapterClasses) {
        AdapterManagerTestHelper.registerAdapterFactory(adapterFactory, adaptableClasses, adapterClasses);
    }

    public static void registerAdapterFactory(long bundleId, long serviceId, AdapterFactory adapterFactory, String[] adaptableClasses, String[] adapterClasses) {
        AdapterManagerTestHelper.registerAdapterFactory(bundleId, serviceId, adapterFactory, adaptableClasses, adapterClasses);
    }

    public static void resetAdapterFactories() {
        AdapterManagerTestHelper.resetAdapterFactories();
    }
}

